/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.net;

import com.isencia.message.ISenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import com.isencia.message.net.SocketClientSenderChannel;
import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ChannelSink;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.gui.IOptionsFactory;
import com.isencia.passerelle.actor.net.SocketSvrRcvOptionsFactory;
import com.isencia.passerelle.core.PasserelleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class SocketClientSender
extends ChannelSink {
    private static Logger logger = LoggerFactory.getLogger(SocketClientSender.class);
    protected int port = 3333;
    protected String host = "localhost";
    public Parameter msgGeneratorType;
    static final String MSG_GENERATOR_PARAM_NAME = "Msg End";
    public Parameter portParam = new Parameter((NamedObj)this, "port", (Token)new IntToken(this.getPort()));
    public Parameter hostParam;

    public SocketClientSender(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.portParam.setTypeEquals((Type)BaseType.INT);
        this.hostParam = new StringParameter((NamedObj)this, "remote host");
        this.hostParam.setExpression(this.getHost());
        this.msgGeneratorType = new StringParameter((NamedObj)this, MSG_GENERATOR_PARAM_NAME);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.portParam) {
            IntToken intToken = (IntToken)this.portParam.getToken();
            if (intToken != null && intToken.intValue() > 0) {
                this.port = intToken.intValue();
            }
        } else if (attribute == this.hostParam) {
            StringToken stringToken = (StringToken)this.hostParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.host = stringToken.stringValue();
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.getHost()) + ":" + this.getPort();
    }

    protected ISenderChannel createChannel() throws InitializationException {
        IMessageGenerator iMessageGenerator = this.getGeneratorFromSelectedOption();
        return new SocketClientSenderChannel(this.getHost(), this.getPort(), iMessageGenerator);
    }

    private IMessageGenerator getGeneratorFromSelectedOption() throws InitializationException {
        IMessageGenerator iMessageGenerator = null;
        try {
            IOptionsFactory.Option option;
            if (this.getOptionsFactory() == null) {
                this.setOptionsFactory((IOptionsFactory)new SocketSvrRcvOptionsFactory((Actor)this, "_optionsFactory"));
            }
            if ((option = this.getOptionsFactory().getOption(this.msgGeneratorType, this.msgGeneratorType.getExpression())) == null) {
                option = this.getOptionsFactory().getDefaultOption(this.msgGeneratorType);
            }
            iMessageGenerator = ((IMessageGenerator)option.getAssociatedObject()).cloneGenerator();
        }
        catch (Exception exception) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Error setting Parameter options factory", (Object)this, (Throwable)exception);
        }
        return iMessageGenerator;
    }
}

