/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.mail;

import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.internal.MessageContainer;
import com.isencia.passerelle.message.internal.PasserelleBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailMessageToMessageConverter
implements IMessageInterceptor {
    private static Logger logger = LoggerFactory.getLogger(MailMessageToMessageConverter.class);
    private String[] contentTypes = null;
    private boolean attachInMessage = false;

    public Object accept(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Accepting ~" + object.toString() + "~");
        }
        ManagedMessage managedMessage = null;
        if (object != null) {
            Object object2;
            managedMessage = MessageFactory.getInstance().createMessage();
            MimeMessage mimeMessage = (MimeMessage)object;
            logger.debug("Creating new MessageContainer");
            Enumeration enumeration = mimeMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                object2 = (Header)enumeration.nextElement();
                logger.debug("Name : " + object2.getName() + ", Value : " + object2.getValue());
                managedMessage.addBodyHeader(object2.getName(), object2.getValue());
            }
            if (this.contentTypes == null && !this.attachInMessage) {
                return managedMessage;
            }
            object2 = mimeMessage.getContent();
            if (object2 instanceof String) {
                logger.debug("Content is String");
                if (this.contentTypes != null && MessageHelper.filterContent((Part)mimeMessage, (String[])this.contentTypes)) {
                    logger.debug("Content is Valid Content Type");
                    managedMessage.setBodyContentPlainText((String)object2);
                }
            } else if (object2 instanceof Multipart) {
                logger.debug("Content is Multipart");
                MultipartContentBuilder multipartContentBuilder = new MultipartContentBuilder();
                Multipart multipart = multipartContentBuilder.build((Multipart)object2, this.contentTypes, this.attachInMessage);
                if (multipart != null) {
                    logger.debug("Multipart added to BodyContent");
                    ((MessageContainer)managedMessage).setBodyContent(multipart);
                } else {
                    logger.debug("No Multipart added to BodyContent");
                }
            } else if (object2 instanceof InputStream) {
                logger.debug("Content is Inputstream");
            }
        }
        return managedMessage;
    }

    public String[] getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(String[] stringArray) {
        this.contentTypes = stringArray;
    }

    public boolean isAttachInMessage() {
        return this.attachInMessage;
    }

    public void setAttachInMessage(boolean bl) {
        this.attachInMessage = bl;
    }

    private class BodyPartContentBuilder {
        private BodyPartContentBuilder() {
        }

        public Part build(Part part, String[] stringArray, boolean bl) throws IOException, MessagingException {
            Object object = part.getContent();
            if (object instanceof String) {
                boolean bl2;
                boolean bl3 = bl2 = !MessageHelper.isContent((Part)part);
                if (bl2) {
                    logger.debug("Is attach");
                    if (!bl) {
                        return null;
                    }
                    return part;
                }
                logger.debug("Is no attach");
                if (!MessageHelper.filterContent((Part)part, (String[])stringArray)) {
                    logger.debug("Not a supported type");
                    return null;
                }
                logger.debug("Supported type");
                return part;
            }
            if (object instanceof InputStream) {
                boolean bl4;
                logger.debug("Bodypart contains an inputstram");
                boolean bl5 = bl4 = !MessageHelper.isContent((Part)part);
                if (bl4) {
                    logger.debug("Is attach");
                    if (!bl) {
                        return null;
                    }
                    logger.debug("Should send attach of Inputstream");
                    PasserelleBodyPart passerelleBodyPart = new PasserelleBodyPart();
                    passerelleBodyPart.setText("");
                    MessageHelper.copyHeaders((Part)part, (Part)passerelleBodyPart);
                    passerelleBodyPart.saveChanges();
                    logger.debug("return just the headers");
                    return passerelleBodyPart;
                }
                logger.debug("Is no attach");
                if (!MessageHelper.filterContent((Part)part, (String[])stringArray)) {
                    logger.debug("Not a supported type");
                    return null;
                }
                logger.debug("Supported type");
                logger.debug("return inputstream in future");
            } else if (object instanceof Multipart) {
                logger.debug("Bodypart contains a multipart");
                MultipartContentBuilder multipartContentBuilder = new MultipartContentBuilder();
                Multipart multipart = multipartContentBuilder.build((Multipart)object, stringArray, bl);
                if (multipart != null && multipart.getCount() > 0) {
                    PasserelleBodyPart passerelleBodyPart = new PasserelleBodyPart();
                    passerelleBodyPart.setText("");
                    MessageHelper.copyHeaders((Part)part, (Part)passerelleBodyPart);
                    passerelleBodyPart.setContent(multipart);
                    passerelleBodyPart.saveChanges();
                    return passerelleBodyPart;
                }
            }
            return null;
        }
    }

    private class MultipartContentBuilder {
        private MultipartContentBuilder() {
        }

        public Multipart build(Multipart multipart, String[] stringArray, boolean bl) throws IOException, MessagingException {
            logger.debug("Start building multipart");
            MimeMultipart mimeMultipart = new MimeMultipart();
            int n = multipart.getCount();
            logger.debug("Building Multipart, found " + n + " parts");
            int n2 = 0;
            while (n2 < n) {
                BodyPart bodyPart = multipart.getBodyPart(n2);
                logger.debug("Bodypart " + n2);
                BodyPartContentBuilder bodyPartContentBuilder = new BodyPartContentBuilder();
                logger.debug("Start Bodypart build");
                Part part = bodyPartContentBuilder.build((Part)bodyPart, stringArray, bl);
                if (part != null) {
                    logger.debug("Bodypart is added");
                    mimeMultipart.addBodyPart((BodyPart)part);
                }
                ++n2;
            }
            if (mimeMultipart.getCount() == 0) {
                return null;
            }
            return mimeMultipart;
        }
    }
}

