/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.io;

import com.isencia.message.IReceiverChannel;
import com.isencia.message.extractor.EndOfMsgCharMsgExtractor;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.extractor.TextLineMessageExtractor;
import com.isencia.message.extractor.XmlMessageExtractor;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.message.io.FileReceiverChannel;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TriggeredChannelSource;
import com.isencia.passerelle.message.interceptor.IMessageCreator;
import com.isencia.passerelle.message.interceptor.ManagedMessageConverter;
import com.isencia.passerelle.message.interceptor.TextToMessageConverter;
import com.isencia.passerelle.message.interceptor.XMLToMessageConverter;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class FileReader
extends TriggeredChannelSource {
    private static Logger logger = LoggerFactory.getLogger(FileReader.class);
    public static final String PATH_PARAM = "Path";
    public static final String INPUTTYPE_PARAM = "Input Type";
    public static final String ENCODING_PARAM = "Encoding";
    private String sourcePath = null;
    private String fileEncoding = null;
    private InputType inputType = null;
    public FileParameter sourcePathParam = new FileParameter((NamedObj)this, "Path");
    public Parameter inputTypeParam = null;
    public Parameter fileEncodingParam = null;

    public FileReader(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        try {
            URI uRI = new URI("file://" + StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder()));
            this.sourcePathParam.setBaseDirectory(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.registerConfigurableParameter((Parameter)this.sourcePathParam);
        this.fileEncodingParam = new StringParameter((NamedObj)this, ENCODING_PARAM);
        this.registerConfigurableParameter(this.fileEncodingParam);
        this.inputType = InputType.TEXT_LINES;
        this.inputTypeParam = new StringParameter((NamedObj)this, INPUTTYPE_PARAM);
        int n = 0;
        while (n < InputType.choices.length) {
            this.inputTypeParam.addChoice(InputType.choices[n].getLabel());
            ++n;
        }
        this.registerConfigurableParameter(this.inputTypeParam);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
            }
            if (attribute == this.fileEncodingParam) {
                try {
                    this.setFileEncoding(this.fileEncodingParam.getExpression());
                    logger.debug("fileEncoding changed to : " + this.getFileEncoding());
                }
                catch (NullPointerException nullPointerException) {}
            } else if (attribute == this.sourcePathParam) {
                try {
                    this.setSourcePath(this.sourcePathParam.asFile().getPath());
                    logger.debug("Source Path changed to : " + this.getSourcePath());
                    this.getStandardMessageHeaders().put("__PSRL_SRC_INFO", this.getSourcePath());
                }
                catch (NullPointerException nullPointerException) {}
            } else if (attribute == this.inputTypeParam) {
                String string = this.inputTypeParam.getExpression();
                String string2 = this.getInputType().getLabel();
                try {
                    InputType inputType = InputType.getInputTypeForLabel(string);
                    if (inputType != null) {
                        this.setInputType(inputType);
                        logger.debug("Mime Type changed to : " + this.getInputType());
                        break block15;
                    }
                    this.inputTypeParam.setExpression(string2);
                }
                catch (Exception exception) {
                    this.inputTypeParam.setExpression(string2);
                }
            } else {
                super.attributeChanged(attribute);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.getSourcePath();
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        boolean bl = true;
        if (!(this.getChannel().isOpen() || this.getSourcePath() != null && this.getSourcePath().length() != 0)) {
            this.requestFinish();
            bl = false;
        }
        if (bl) {
            bl = super.doPreFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    protected String getFileEncoding() {
        return this.fileEncoding;
    }

    protected void setFileEncoding(String string) {
        this.fileEncoding = string;
    }

    protected void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    protected IReceiverChannel createChannel() {
        if (this.getFileEncoding() != null && this.getFileEncoding().length() > 0) {
            return new FileReceiverChannel(new File(this.getSourcePath()), this.getFileEncoding(), this.getInputType().getMsgExtractor().cloneExtractor());
        }
        return new FileReceiverChannel(new File(this.getSourcePath()), this.getInputType().getMsgExtractor().cloneExtractor());
    }

    protected IMessageInterceptorChain createInterceptorChain() {
        MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
        messageInterceptorChain.add((IMessageInterceptor)this.getInputType().getMsgConverter().cloneConverter((IMessageCreator)this));
        return messageInterceptorChain;
    }

    private static class InputType {
        public static final InputType TEXT_LINES = new InputType("text-lines", "text/plain", (IMessageExtractor)new TextLineMessageExtractor(), (ManagedMessageConverter)new TextToMessageConverter(null));
        public static final InputType TEXT_FILE = new InputType("text-file", "text/plain", (IMessageExtractor)new EndOfMsgCharMsgExtractor(), (ManagedMessageConverter)new TextToMessageConverter(null));
        public static final InputType XML_DOC = new InputType("xml-doc", "text/xml", (IMessageExtractor)new XmlMessageExtractor(), (ManagedMessageConverter)new XMLToMessageConverter(null));
        public static final InputType[] choices = new InputType[]{TEXT_LINES, TEXT_FILE, XML_DOC};
        private String label;
        private String mimeType;
        private IMessageExtractor msgExtractor;
        private ManagedMessageConverter msgConverter;

        public static InputType getInputTypeForLabel(String string) {
            InputType inputType = null;
            int n = 0;
            while (n < choices.length) {
                InputType inputType2 = choices[n];
                if (inputType2.getLabel().equals(string)) {
                    inputType = choices[n];
                    break;
                }
                ++n;
            }
            return inputType;
        }

        private InputType(String string, String string2, IMessageExtractor iMessageExtractor, ManagedMessageConverter managedMessageConverter) {
            this.label = string;
            this.mimeType = string2;
            this.msgExtractor = iMessageExtractor;
            this.msgConverter = managedMessageConverter;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public IMessageExtractor getMsgExtractor() {
            return this.msgExtractor;
        }

        public ManagedMessageConverter getMsgConverter() {
            return this.msgConverter;
        }
    }
}

