/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.ftp;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.ftp.FtpSenderChannel;
import com.isencia.passerelle.actor.ftp.FtpWriter;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class FtpFileWriter
extends FtpWriter {
    private static Logger logger = LoggerFactory.getLogger(FtpFileWriter.class);
    public Parameter overwriteParam = new Parameter((NamedObj)this, "Overwrite existing file", (Token)new BooleanToken(this.overwrite));
    private boolean overwrite = false;
    private static final String OVERWRITE_PARAM = "Overwrite existing file";

    public FtpFileWriter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.overwriteParam.setTypeEquals((Type)BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.overwriteParam) {
            BooleanToken booleanToken = (BooleanToken)this.overwriteParam.getToken();
            if (booleanToken != null) {
                this.overwrite = booleanToken.booleanValue();
                logger.debug("Overwrite changed to : " + this.overwrite);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            if (managedMessage.getBodyHeader("toFile") != null) {
                if (this.getChannel().isOpen()) {
                    this.getChannel().close();
                }
                String string = managedMessage.getBodyHeader("toFile")[0];
                ((FtpSenderChannel)this.getChannel()).setRemoteFileName(string);
                this.getChannel().open();
            }
            this.getChannel().sendMessage((Object)managedMessage);
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Sent message :" + managedMessage);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + exception, (Object)managedMessage, (Throwable)exception);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }
}

