/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.flow;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Synchronizer
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(Synchronizer.class);
    public static final String NUMBER_OF_PORTS = "Extra nr of ports";
    public static final String INPUTPORTPREFIX = "input";
    public static final String OUTPUTPORTPREFIX = "output";
    public Port syncInput = PortFactory.getInstance().createInputPort((Actor)this, "syncInput", null);
    private PortHandler syncInputHandler = null;
    private List<Port> inputPorts = new ArrayList<Port>(5);
    private List<Port> outputPorts = new ArrayList<Port>(5);
    private List<Boolean> finishRequests = new ArrayList<Boolean>(5);
    public Parameter numberOfPorts = new Parameter((NamedObj)this, "Extra nr of ports", (Token)new IntToken(0));

    public Synchronizer(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.numberOfPorts.setTypeEquals((Type)BaseType.INT);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"0\" y1=\"-15\" x2=\"0\" y2=\"15\" style=\"stroke-width:3.0\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-3\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"3\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-15\" y1=\"-10\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-13\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-7\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-15\" y1=\"10\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"7\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"13\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"1\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"1\" y1=\"-10\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-13\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-7\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"1\" y1=\"10\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"7\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"13\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n</svg>\n");
    }

    protected String getExtendedInfo() {
        return this.numberOfPorts != null ? this.numberOfPorts.getExpression() : "0";
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        int n = 0;
        while (n < this.finishRequests.size()) {
            this.finishRequests.set(n, Boolean.FALSE);
            ++n;
        }
        this.syncInputHandler = new PortHandler((IOPort)this.syncInput);
        if (this.syncInput.getWidth() > 0) {
            this.syncInputHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry");
        }
        this.isFiring = false;
        Token token = this.syncInputHandler.getToken();
        this.isFiring = true;
        if (token != null) {
            ManagedMessage managedMessage;
            Port port;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - doFire() - received msg on port " + this.syncInput.getName());
            }
            int n = this.inputPorts.size();
            ManagedMessage[] managedMessageArray = new ManagedMessage[n];
            int n2 = 0;
            while (n2 < n) {
                if (!this.finishRequests.get(n2).booleanValue()) {
                    port = this.inputPorts.get(n2);
                    try {
                        managedMessage = MessageHelper.getMessage((IOPort)port);
                        if (managedMessage != null) {
                            managedMessageArray[n2] = managedMessage;
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.valueOf(this.getInfo()) + " doFire() - received msg on port " + port.getName());
                            }
                        } else {
                            this.finishRequests.set(n2, Boolean.TRUE);
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + port.getName());
                            }
                        }
                    }
                    catch (PasserelleException passerelleException) {
                        throw new ProcessingException("Error reading from port", (Object)port, (Throwable)passerelleException);
                    }
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                if (!this.finishRequests.get(n2).booleanValue()) {
                    port = this.outputPorts.get(n2);
                    managedMessage = managedMessageArray[n2];
                    if (managedMessage != null) {
                        this.sendOutputMsg(port, managedMessage);
                    }
                }
                ++n2;
            }
            if (this.areAllInputsFinished()) {
                this.requestFinish();
            }
        } else {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return null;
    }

    private boolean areAllInputsFinished() {
        boolean bl = true;
        int n = 0;
        while (n < this.finishRequests.size()) {
            bl = bl && this.finishRequests.get(n) != false;
            ++n;
        }
        return bl;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - entry - attribute :" + attribute);
        }
        if (attribute == this.numberOfPorts) {
            int n = this.inputPorts.size();
            int n2 = ((IntToken)this.numberOfPorts.getToken()).intValue();
            if (n2 < n) {
                int n3 = n - 1;
                while (n3 >= n2) {
                    try {
                        this.inputPorts.get(n3).setContainer(null);
                        this.inputPorts.remove(n3);
                        this.outputPorts.get(n3).setContainer(null);
                        this.outputPorts.remove(n3);
                        this.finishRequests.remove(n3);
                    }
                    catch (NameDuplicationException nameDuplicationException) {}
                    --n3;
                }
            } else if (n2 > n) {
                int n4 = n;
                while (n4 < n2) {
                    try {
                        Port port;
                        String string = INPUTPORTPREFIX + n4;
                        String string2 = OUTPUTPORTPREFIX + n4;
                        Port port2 = (Port)this.getPort(string);
                        if (port2 == null) {
                            port2 = PortFactory.getInstance().createInputPort((Actor)this, string, null);
                            port2.setMultiport(false);
                        }
                        if ((port = (Port)this.getPort(string2)) == null) {
                            port = PortFactory.getInstance().createOutputPort((Actor)this, string2);
                        }
                        this.inputPorts.add(port2);
                        this.outputPorts.add(port);
                        this.finishRequests.add(Boolean.FALSE);
                    }
                    catch (NameDuplicationException nameDuplicationException) {
                        logger.error("", (Throwable)nameDuplicationException);
                        throw new IllegalActionException((Nameable)this, (Throwable)nameDuplicationException, "Error for index " + n4);
                    }
                    ++n4;
                }
            }
            n = n2;
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - exit");
        }
    }
}

