/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.filter;

import com.isencia.passerelle.actor.Filter;
import com.isencia.passerelle.actor.FilterException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.xml.XmlMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class XPathFilter
extends Filter {
    private static Logger logger = LoggerFactory.getLogger(XPathFilter.class);
    public Parameter expressionParam = new StringParameter((NamedObj)this, "Expression");
    private String expression = null;

    public XPathFilter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.expressionParam.setExpression("");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.expressionParam) {
            String string;
            this.expression = string = ((StringToken)this.expressionParam.getToken()).stringValue();
            logger.debug("Expression set to : " + this.expression);
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.expression;
    }

    protected boolean isMatchingFilter(Object object) throws FilterException {
        boolean bl = false;
        if (this.expression == null || this.expression.length() == 0) {
            bl = true;
        } else if (object instanceof ManagedMessage) {
            ManagedMessage managedMessage = (ManagedMessage)object;
            try {
                NodeList nodeList = XmlMessageHelper.selectWithXPath((String)this.expression, (ManagedMessage)managedMessage);
                bl = nodeList != null && nodeList.getLength() > 0;
                logger.debug("Does " + (bl ? "" : "not") + " match " + this.expression);
            }
            catch (Exception exception) {
                throw new FilterException(String.valueOf(this.getInfo()) + " exception in isMatchingFilter() :" + exception, object, (Throwable)exception);
            }
        }
        return bl;
    }
}

