/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.filter;

import com.isencia.passerelle.actor.Filter;
import com.isencia.passerelle.actor.FilterException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class RegexpFilter
extends Filter {
    private static Logger logger = LoggerFactory.getLogger(RegexpFilter.class);
    public Parameter expressionParam = new StringParameter((NamedObj)this, "Expression");
    private String expression = null;

    public RegexpFilter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.expressionParam.setExpression("");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.expressionParam) {
            String string = ((StringToken)this.expressionParam.getToken()).stringValue();
            try {
                new RE(string);
                this.expression = string;
                logger.debug("Expression set to : " + this.expression);
            }
            catch (RESyntaxException rESyntaxException) {
                throw new IllegalActionException("Invalid RegExp expression : " + string + " : " + rESyntaxException.getMessage());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean isMatchingFilter(Object object) throws FilterException {
        boolean bl = false;
        if (this.expression == null || this.expression.length() == 0) {
            bl = true;
        } else if (object instanceof ManagedMessage) {
            ManagedMessage managedMessage = (ManagedMessage)object;
            Object[] objectArray = MessageHelper.getFilteredContent((ManagedMessage)managedMessage, (String[])new String[]{"text/plain", "text/html", "text/xml"});
            if (objectArray != null && objectArray.length > 0) {
                try {
                    RE rE = new RE(this.expression);
                    int n = 0;
                    while (n < objectArray.length && !bl) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Content :" + objectArray[n]);
                        }
                        if (objectArray[n] instanceof String) {
                            bl = rE.match((String)objectArray[n]);
                            if (logger.isDebugEnabled() && bl) {
                                logger.debug("Matches :" + this.expression);
                            }
                        }
                        ++n;
                    }
                }
                catch (RESyntaxException rESyntaxException) {
                    throw new FilterException("Invalid RegExp expression : " + this.expression + " : " + (Object)((Object)rESyntaxException), object, (Throwable)rESyntaxException);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " : no valid content in " + object);
            }
        }
        return bl;
    }

    protected String getExtendedInfo() {
        return this.expression;
    }
}

