/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ExceptionGenerator
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(ExceptionGenerator.class);
    public Parameter exceptionClassName = new StringParameter((NamedObj)this, "Throwable class");
    public Parameter severity;

    public ExceptionGenerator(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.exceptionClassName.setExpression("java.lang.NullPointerException");
        this.registerConfigurableParameter(this.exceptionClassName);
        this.severity = new StringParameter((NamedObj)this, "Severity for non-RuntimeExceptions");
        this.severity.setExpression(PasserelleException.Severity.FATAL.toString());
        this.severity.addChoice(PasserelleException.Severity.FATAL.toString());
        this.severity.addChoice(PasserelleException.Severity.NON_FATAL.toString());
        this.registerConfigurableParameter(this.severity);
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        Class clazz = NullPointerException.class;
        String string = this.exceptionClassName.getExpression();
        Throwable throwable = null;
        try {
            clazz = Class.forName(string);
            throwable = (Throwable)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.warn("Error constructing exception instance for :" + string + " -- using NPE as default", (Throwable)exception);
            throwable = new NullPointerException();
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        PasserelleException.Severity severity = PasserelleException.Severity.NON_FATAL;
        if (PasserelleException.Severity.FATAL.toString().equals(this.severity.getExpression())) {
            severity = PasserelleException.Severity.FATAL;
        }
        throw new ProcessingException(severity, "generated exception", (Object)this, throwable);
    }

    protected String getExtendedInfo() {
        return this.exceptionClassName.getExpression();
    }
}

