/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.v3.ActorContext;
import com.isencia.passerelle.actor.v3.ProcessRequest;
import com.isencia.passerelle.actor.v3.ProcessResponse;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.message.ManagedMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ErrorReceiver
extends com.isencia.passerelle.actor.v3.Actor
implements ErrorCollector {
    private static Logger logger = LoggerFactory.getLogger(ErrorReceiver.class);
    private BlockingQueue<PasserelleException> errors = new LinkedBlockingQueue<PasserelleException>();
    public Port output = PortFactory.getInstance().createOutputPort((Actor)this);

    public ErrorReceiver(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        try {
            ((Director)this.getDirector()).addErrorCollector((ErrorCollector)this);
        }
        catch (ClassCastException classCastException) {
            logger.info(String.valueOf(this.getInfo()) + " - used without Passerelle Director!!");
        }
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        try {
            PasserelleException passerelleException = this.errors.poll(1L, TimeUnit.SECONDS);
            if (passerelleException != null) {
                ManagedMessage managedMessage = this.createErrorMessage(passerelleException);
                processResponse.addOutputMessage(0, this.output, managedMessage);
                this.drainErrorsQueueTo(processResponse);
            }
        }
        catch (InterruptedException interruptedException) {
            this.requestFinish();
        }
    }

    private void drainErrorsQueueTo(ProcessResponse processResponse) throws ProcessingException {
        while (!this.errors.isEmpty()) {
            PasserelleException passerelleException = (PasserelleException)((Object)this.errors.poll());
            if (passerelleException == null) break;
            ManagedMessage managedMessage = this.createErrorMessage(passerelleException);
            if (processResponse != null) {
                processResponse.addOutputMessage(0, this.output, managedMessage);
                continue;
            }
            this.sendOutputMsg(this.output, managedMessage);
        }
    }

    public void acceptError(PasserelleException passerelleException) {
        try {
            this.errors.put(passerelleException);
        }
        catch (InterruptedException interruptedException) {
            logger.error("Receipt interrupted for ", (Throwable)passerelleException);
        }
    }

    protected void doWrapUp() throws TerminationException {
        try {
            ((Director)this.getDirector()).removeErrorCollector((ErrorCollector)this);
        }
        catch (ClassCastException classCastException) {}
        try {
            this.drainErrorsQueueTo(null);
        }
        catch (Exception exception) {
            throw new TerminationException(String.valueOf(this.getInfo()) + " - doWrapUp() generated exception " + exception, this.errors, (Throwable)exception);
        }
        super.doWrapUp();
    }
}

