/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import com.isencia.passerelle.message.internal.ErrorMessageListContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ErrorCollector
extends Actor
implements com.isencia.passerelle.ext.ErrorCollector {
    private static final Logger logger = LoggerFactory.getLogger(ErrorCollector.class);
    public Port input;
    private PortHandler inputHandler = null;
    public Port output;
    private List errorsReceived = new ArrayList();

    public ErrorCollector(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.input = PortFactory.getInstance().createInputPort((Actor)this, "input", null);
        this.output = PortFactory.getInstance().createOutputPort((Actor)this, "output");
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.inputHandler = new PortHandler((IOPort)this.input);
        if (this.input.getWidth() > 0) {
            this.inputHandler.start();
        }
        this.errorsReceived.clear();
        try {
            ((Director)this.getDirector()).addErrorCollector((com.isencia.passerelle.ext.ErrorCollector)this);
        }
        catch (ClassCastException classCastException) {
            logger.info(String.valueOf(this.getInfo()) + " - used without Passerelle Director!!");
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.isFiring = false;
        Token token = this.inputHandler.getToken();
        this.isFiring = true;
        if (token != null) {
            ManagedMessage managedMessage = null;
            try {
                managedMessage = MessageHelper.getMessageFromToken((Token)token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error reading message from token", (Object)token, (Throwable)passerelleException);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Transformer received message :" + managedMessage);
            }
            this.doFire(managedMessage);
        } else {
            this.performWait(-1);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - received " + managedMessage);
        }
        if (managedMessage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - adding error message " + managedMessage);
            }
            if (managedMessage instanceof ErrorMessageContainer) {
                this.errorsReceived.add(managedMessage);
            } else {
                this.errorsReceived.add(this.createErrorMessage((PasserelleException)new ProcessingException("misc error rcv " + new Date().toString(), (Object)managedMessage, null)));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doWrapUp() throws TerminationException {
        block11: {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getInfo());
            }
            try {
                try {
                    ((Director)this.getDirector()).removeErrorCollector((com.isencia.passerelle.ext.ErrorCollector)this);
                }
                catch (ClassCastException classCastException) {
                    logger.info(String.valueOf(this.getInfo()) + " - used without Passerelle Director!!");
                }
                if (this.errorsReceived.size() <= 0) break block11;
                ErrorMessageListContainer errorMessageListContainer = new ErrorMessageListContainer();
                for (ErrorMessageContainer errorMessageContainer : this.errorsReceived) {
                    errorMessageListContainer.addErrorMessage(errorMessageContainer);
                }
                try {
                    this.sendOutputMsg(this.output, (ManagedMessage)errorMessageListContainer);
                }
                catch (Exception exception) {
                    throw new TerminationException(String.valueOf(this.getInfo()) + " - doWrapUp() generated exception " + exception, (Object)errorMessageListContainer, (Throwable)exception);
                }
                if (ErrorCollector.getAuditLogger().isInfoEnabled()) {
                    ErrorCollector.getAuditLogger().info("Sent error message with " + this.errorsReceived.size() + " entries");
                }
            }
            finally {
                super.doWrapUp();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return null;
    }

    protected String getExtendedInfo() {
        return "";
    }

    public void acceptError(PasserelleException passerelleException) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - received :" + (Object)((Object)passerelleException));
        }
        if (passerelleException != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - adding error " + (Object)((Object)passerelleException));
            }
            this.errorsReceived.add(this.createErrorMessage(passerelleException));
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    private synchronized void performWait(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + n);
        }
        try {
            if (n == -1) {
                ((Object)((Object)this)).wait();
            } else {
                ((Object)((Object)this)).wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    private synchronized void performNotify() {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        ((Object)((Object)this)).notify();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doStopFire() {
        this.performNotify();
    }

    protected void doStop() {
        this.performNotify();
    }
}

