/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.error;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TriggeredSource;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ConstError
extends TriggeredSource {
    private static Logger logger = LoggerFactory.getLogger(ConstError.class);
    protected boolean messageSent = false;
    public Parameter value = new StringParameter((NamedObj)this, "value");
    public Parameter severity = new StringParameter((NamedObj)this, "severity");

    public ConstError(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.severity.setExpression(PasserelleException.Severity.FATAL.toString());
        this.severity.addChoice(PasserelleException.Severity.FATAL.toString());
        this.severity.addChoice(PasserelleException.Severity.NON_FATAL.toString());
        this.output.setTypeAtLeast((Typeable)this.value);
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.messageSent = false;
        super.doInitialize();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected ManagedMessage getMessage() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.messageSent && !this.isTriggerConnected()) {
            return null;
        }
        ManagedMessage managedMessage = null;
        try {
            try {
                ProcessingException processingException = this.createException();
                managedMessage = this.createErrorMessage((PasserelleException)processingException);
            }
            catch (Exception exception) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - getMessage() generated exception " + exception, (Object)this.value, (Throwable)exception);
            }
        }
        finally {
            this.messageSent = true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
        return managedMessage;
    }

    protected ProcessingException createException() {
        String string = this.value.getExpression();
        PasserelleException.Severity severity = PasserelleException.Severity.NON_FATAL;
        if (PasserelleException.Severity.FATAL.toString().equals(this.severity.getExpression())) {
            severity = PasserelleException.Severity.FATAL;
        }
        ProcessingException processingException = new ProcessingException(severity, string, (Object)this, null);
        return processingException;
    }

    protected String getExtendedInfo() {
        return this.value.getExpression();
    }

    protected boolean mustWaitForTrigger() {
        return true;
    }
}

