/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.convert.DynamicPortScriptConverter;
import com.isencia.passerelle.actor.dynaport.DynamicPortsActor;
import com.isencia.passerelle.actor.v3.ActorContext;
import com.isencia.passerelle.actor.v3.ProcessRequest;
import com.isencia.passerelle.actor.v3.ProcessResponse;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortMode;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MultiMessageFlowElement;
import java.util.Iterator;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class SynchronizingScriptConverter
extends DynamicPortScriptConverter {
    private static Logger logger = LoggerFactory.getLogger(SynchronizingScriptConverter.class);
    private BSFManager scriptManager = new BSFManager();

    public SynchronizingScriptConverter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        if (this.hasEqualNumberOfInputAndOutputPorts()) {
            if (this.numberOfOutputs != null) {
                this.numberOfOutputs.setContainer(null);
                this.numberOfOutputs = null;
            }
            if (this.numberOfInputs != null) {
                this.numberOfInputs.setName("Nr of ports");
            }
        }
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"0\" y1=\"-15\" x2=\"0\" y2=\"15\" style=\"stroke-width:3.0\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-3\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"3\" x2=\"-1\" y2=\"0\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-15\" y1=\"-10\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-13\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"-7\" x2=\"-1\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-15\" y1=\"10\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"7\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-5\" y1=\"13\" x2=\"-1\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"1\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"1\" y1=\"-10\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-13\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-7\" x2=\"15\" y2=\"-10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"1\" y1=\"10\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"7\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"13\" x2=\"15\" y2=\"10\" style=\"stroke-width:2.0;stroke:blue\"/>\n</svg>\n");
    }

    protected boolean hasEqualNumberOfInputAndOutputPorts() {
        return true;
    }

    @Override
    protected void initializeScriptingEngines() {
        this.scriptManager = new BSFManager();
        this.scriptManager.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.bsfManagers.add(this.scriptManager);
    }

    @Override
    protected void changeNumberOfPorts(int n, int n2, DynamicPortsActor.PortType portType) throws IllegalActionException, IllegalArgumentException {
        if (this.hasEqualNumberOfInputAndOutputPorts()) {
            super.changeNumberOfPorts(n, n2, DynamicPortsActor.PortType.INPUT);
            super.changeNumberOfPorts(n, n2, DynamicPortsActor.PortType.OUTPUT);
            this.nrOutputPorts = n;
            this.nrInputPorts = n;
        } else {
            super.changeNumberOfPorts(n, n2, portType);
        }
    }

    @Override
    protected PortMode getPortModeForNewInputPort(String string) {
        return PortMode.PULL;
    }

    @Override
    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        MultiMessageFlowElement.MessageAndPort[] messageAndPortArray;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " process() - entry - request : " + processRequest);
        }
        MultiMessageFlowElement multiMessageFlowElement = new MultiMessageFlowElement(this.getNrInputPorts(), this.getNrOutputPorts());
        Iterator iterator = processRequest.getAllInputContexts();
        while (iterator.hasNext()) {
            messageAndPortArray = (MultiMessageFlowElement.MessageAndPort[])iterator.next();
            multiMessageFlowElement.addInputSpec(messageAndPortArray.getPortIndex(), messageAndPortArray.getMsg());
        }
        if (this.isMockMode()) {
            int n = 0;
            try {
                for (Port port : this.getOutputPorts()) {
                    this.sendOutputMsg(port, this.createMessage(new Integer(n).toString(), "application/java"));
                    ++n;
                }
            }
            catch (MessageException messageException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - OUTPUT PORT ERROR - Error creating output message", null, (Throwable)messageException);
            }
        }
        this.processMessages(multiMessageFlowElement);
        messageAndPortArray = multiMessageFlowElement.getAllOutputSpecs();
        int n = 0;
        while (n < messageAndPortArray.length) {
            MultiMessageFlowElement.MessageAndPort messageAndPort = messageAndPortArray[n];
            Port port = this.getOutputPorts().get(messageAndPort.portNr);
            try {
                this.sendOutputMsg(port, messageAndPort.message);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - process() generated exception " + illegalArgumentException, (Object)messageAndPort.message, (Throwable)illegalArgumentException);
            }
            ++n;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    private void processMessages(MultiMessageFlowElement multiMessageFlowElement) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " processMessage() - entry - input : " + multiMessageFlowElement);
        }
        if (multiMessageFlowElement != null) {
            try {
                this.scriptManager.declareBean(this.containerName, (Object)multiMessageFlowElement, multiMessageFlowElement.getClass());
                this.scriptManager.exec(this.language, this.scriptPath, -1, -1, (Object)this.script);
            }
            catch (BSFException bSFException) {
                throw new ProcessingException("", (Object)this.scriptPath, (Throwable)bSFException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " processMessage() - exit");
        }
    }
}

