/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFlowElement;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ScriptConverter
extends Transformer {
    public static final String PATH_PARAM = "Path";
    public static final String LANGUAGE_PARAM = "Language";
    public static final String CONTAINERNAME_PARAM = "Container name";
    private static Logger logger = LoggerFactory.getLogger(ScriptConverter.class);
    private BSFManager manager = new BSFManager();
    public StringParameter languageParam = null;
    public FileParameter scriptPathParam = new FileParameter((NamedObj)this, "Path");
    public Parameter containerNameParam = null;
    private String containerName = "";
    private String language = "";
    private String script = null;
    private String scriptPath = null;

    public ScriptConverter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.languageParam = new StringParameter((NamedObj)this, LANGUAGE_PARAM);
        this.languageParam.setExpression("jython");
        this.languageParam.addChoice("javascript");
        this.languageParam.addChoice("jython");
        this.containerNameParam = new StringParameter((NamedObj)this, CONTAINERNAME_PARAM);
        this.containerNameParam.setExpression("container");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.scriptPathParam) {
            try {
                this.scriptPath = this.scriptPathParam.asURL().getPath();
                logger.debug("Path changed to : " + this.scriptPath);
            }
            catch (Exception exception) {}
        } else if (attribute == this.languageParam) {
            StringToken stringToken = (StringToken)this.languageParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.language = stringToken.stringValue();
                logger.debug("Language changed to : " + this.language);
            }
        } else if (attribute == this.containerNameParam) {
            StringToken stringToken = (StringToken)this.containerNameParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.containerName = stringToken.stringValue();
                logger.debug("Container name changed to : " + this.containerName);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - message :" + managedMessage);
        }
        if (managedMessage != null) {
            MessageFlowElement messageFlowElement = new MessageFlowElement(new MessageFlowElement.MessageAndPort(0, managedMessage), 1);
            try {
                this.manager.declareBean(this.containerName, (Object)messageFlowElement, messageFlowElement.getClass());
                this.manager.exec(this.language, this.scriptPath, -1, -1, (Object)this.script);
            }
            catch (BSFException bSFException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - script execution generated an exception " + (Object)((Object)bSFException), (Object)managedMessage, (Throwable)bSFException);
            }
            try {
                this.sendOutputMsg(this.output, messageFlowElement.getOutputMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        try {
            FileReader fileReader = new FileReader(this.scriptPath);
            this.script = IOUtils.getStringFromReader((Reader)fileReader);
            ((Reader)fileReader).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Script file not found.", (Object)this.scriptPath, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Script file could not be opened.", (Object)this.scriptPath, (Throwable)iOException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.scriptPath;
    }
}

