/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class HeaderModifier
extends Transformer {
    private static final String MODE_ADD = "Add";
    private static final String MODE_MODIFY = "Modify";
    private static final String MODE_REMOVE = "Remove";
    private static Logger logger = LoggerFactory.getLogger(HeaderModifier.class);
    private Parameter propNameParam = null;
    private Parameter propValueParam = null;
    private Parameter propModeParam = null;
    private String propName = "";
    private String propValue = "";
    private String propMode = null;

    public HeaderModifier(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.output.setMultiport(true);
        this.propNameParam = new StringParameter((NamedObj)this, "header name");
        this.propNameParam.setExpression("");
        this.propValueParam = new StringParameter((NamedObj)this, "header value");
        this.propValueParam.setExpression("");
        this.propModeParam = new StringParameter((NamedObj)this, "mode");
        this.propModeParam.addChoice(MODE_ADD);
        this.propModeParam.addChoice(MODE_MODIFY);
        this.propModeParam.addChoice(MODE_REMOVE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.propNameParam) {
            this.propName = ((StringToken)this.propNameParam.getToken()).stringValue();
        } else if (attribute == this.propValueParam) {
            this.propValue = ((StringToken)this.propValueParam.getToken()).stringValue();
        } else if (attribute == this.propModeParam) {
            this.propMode = this.propModeParam.getExpression();
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - message :" + managedMessage);
        }
        if (managedMessage != null && this.propName != null && this.propName.length() > 0) {
            try {
                if (this.propMode.equalsIgnoreCase(MODE_ADD)) {
                    managedMessage.addBodyHeader(this.propName, this.propValue);
                } else if (this.propMode.equalsIgnoreCase(MODE_MODIFY)) {
                    managedMessage.setBodyHeader(this.propName, this.propValue);
                } else if (this.propMode.equalsIgnoreCase(MODE_REMOVE)) {
                    managedMessage.removeBodyHeader(this.propName);
                }
            }
            catch (MessageException messageException) {
                throw new ProcessingException(PasserelleException.Severity.NON_FATAL, "", (Object)managedMessage, (Throwable)messageException);
            }
        }
        try {
            this.sendOutputMsg(this.output, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.propMode) + ":" + this.propName + ":" + this.propValue;
    }
}

