/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.dynaport.DynamicPortsActor;
import com.isencia.passerelle.actor.v3.ActorContext;
import com.isencia.passerelle.actor.v3.MessageInputContext;
import com.isencia.passerelle.actor.v3.ProcessRequest;
import com.isencia.passerelle.actor.v3.ProcessResponse;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFlowElement;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.python.core.Py;
import org.python.core.PySystemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class DynamicPortScriptConverter
extends DynamicPortsActor {
    private static final String JAVASCRIPT = "javascript";
    private static final String JYTHON = "jython";
    public static final String PATH_PARAM = "Path";
    public static final String LANGUAGE_PARAM = "Language";
    public static final String CONTAINERNAME_PARAM = "Container name";
    private static Logger logger = LoggerFactory.getLogger(DynamicPortScriptConverter.class);
    protected List<BSFManager> bsfManagers = new ArrayList<BSFManager>();
    protected String script = null;
    public Parameter languageParam = null;
    protected String language = "";
    public Parameter containerNameParam = null;
    protected String containerName = "";
    public FileParameter scriptPathParam = new FileParameter((NamedObj)this, "Path");
    protected String scriptPath = null;

    public DynamicPortScriptConverter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.languageParam = new StringParameter((NamedObj)this, LANGUAGE_PARAM);
        this.languageParam.setExpression(JYTHON);
        this.languageParam.addChoice(JYTHON);
        this.languageParam.addChoice(JAVASCRIPT);
        this.containerNameParam = new StringParameter((NamedObj)this, CONTAINERNAME_PARAM);
        this.containerNameParam.setExpression("container");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged()- entry - attribute :" + attribute);
        }
        if (attribute == this.scriptPathParam) {
            try {
                this.scriptPath = this.scriptPathParam.asURL().getPath();
                logger.debug("Path changed to : " + this.scriptPath);
            }
            catch (Exception exception) {}
        } else if (attribute == this.languageParam) {
            StringToken stringToken = (StringToken)this.languageParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.language = stringToken.stringValue();
                logger.debug("Language changed to : " + this.language);
            }
        } else if (attribute == this.containerNameParam) {
            StringToken stringToken = (StringToken)this.containerNameParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.containerName = stringToken.stringValue();
                logger.debug("Container name changed to : " + this.containerName);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged()- exit");
        }
    }

    public void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        if (!this.isMockMode()) {
            try {
                FileReader fileReader = new FileReader(this.scriptPath);
                this.script = IOUtils.getStringFromReader((Reader)fileReader);
                ((Reader)fileReader).close();
            }
            catch (IOException iOException) {
                throw new InitializationException("Could not read script file", (Object)this, (Throwable)iOException);
            }
            this.initializeScriptingEngines();
            if (JYTHON.equals(this.language)) {
                Py.initPython();
                PySystemState.add_package((String)"be.isencia.passerelle.message");
            }
        }
        super.doInitialize();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - exit");
        }
    }

    protected void initializeScriptingEngines() {
        int n = 0;
        while (n < this.getNrInputPorts()) {
            BSFManager bSFManager = new BSFManager();
            bSFManager.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.bsfManagers.add(bSFManager);
            ++n;
        }
    }

    protected String getExtendedInfo() {
        return this.scriptPath;
    }

    public void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doWrapUp() - entry");
        }
        for (BSFManager bSFManager : this.bsfManagers) {
            bSFManager.terminate();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doWrapUp() - exit");
        }
    }

    protected void process(ActorContext actorContext, ProcessRequest processRequest, ProcessResponse processResponse) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " process() - entry - request : " + processRequest);
        }
        try {
            Iterator iterator = processRequest.getAllInputContexts();
            while (iterator.hasNext()) {
                MessageInputContext messageInputContext = (MessageInputContext)iterator.next();
                if (messageInputContext.isProcessed()) continue;
                int n = messageInputContext.getPortIndex();
                ManagedMessage managedMessage = messageInputContext.getMsg();
                MessageFlowElement messageFlowElement = new MessageFlowElement(new MessageFlowElement.MessageAndPort(n, managedMessage), this.getNrOutputPorts());
                BSFManager bSFManager = this.bsfManagers.get(n);
                bSFManager.declareBean(this.containerName, (Object)messageFlowElement, messageFlowElement.getClass());
                bSFManager.exec(this.language, this.scriptPath, -1, -1, (Object)this.script);
                MessageFlowElement.MessageAndPort[] messageAndPortArray = messageFlowElement.getAllOutputSpecs();
                int n2 = 0;
                while (n2 < messageAndPortArray.length) {
                    MessageFlowElement.MessageAndPort messageAndPort = messageAndPortArray[n2];
                    Port port = this.getOutputPorts().get(messageAndPort.portNr);
                    processResponse.addOutputMessage(messageAndPort.portNr, port, messageAndPort.message);
                    ++n2;
                }
            }
        }
        catch (BSFException bSFException) {
            throw new ProcessingException("", (Object)this.scriptPath, (Throwable)bSFException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " process() - exit");
        }
    }
}

