/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Distributor
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(Distributor.class);

    public Distributor(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.input.setExpectedMessageContentType(String.class);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"10\" y1=\"-15\" x2=\"10\" y2=\"-8\" style=\"stroke-width:3.0\"/>\n<line x1=\"10\" y1=\"8\" x2=\"10\" y2=\"15\" style=\"stroke-width:3.0\"/>\n<line x1=\"-10\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"-10\" y1=\"-10\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-13\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-7\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-10\" y1=\"10\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"7\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"13\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n</svg>\n");
    }

    protected String getExtendedInfo() {
        return null;
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new StringReader(managedMessage.getBodyContentAsString()));
                String string = null;
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    ManagedMessage managedMessage2 = null;
                    try {
                        managedMessage2 = this.createMessage(string, "text/plain");
                    }
                    catch (MessageException messageException) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while building new output message " + (Object)((Object)messageException), (Object)managedMessage2, (Throwable)messageException);
                    }
                    try {
                        this.sendOutputMsg(this.output, managedMessage2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage2, (Throwable)illegalArgumentException);
                    }
                }
                if (Distributor.getAuditLogger().isInfoEnabled()) {
                    Distributor.getAuditLogger().info("Sent " + n + " messages");
                }
            }
            catch (IOException iOException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while reading text from input message " + iOException, (Object)managedMessage, (Throwable)iOException);
            }
            catch (MessageException messageException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while building new output message " + (Object)((Object)messageException), (Object)managedMessage, (Throwable)messageException);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return null;
    }
}

