/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.ChangeEventMulticaster;
import de.jtem.beans.Inspector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class InspectorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final HashMap<Class, Inspector> CLASS_TO_PANEL = new HashMap();
    ChangeListener changeListener;
    private Inspector inspector;
    private Object object;
    JButton refreshButton;

    public InspectorPanel() {
        this(true);
    }

    public InspectorPanel(boolean useRefreshButton) {
        super(new BorderLayout());
        Box titleBox = new Box(0);
        if (useRefreshButton) {
            this.refreshButton = new JButton();
            this.refreshButton.setForeground(Color.red);
            this.refreshButton.setMaximumSize(new Dimension(32000, 20));
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InspectorPanel.this.refresh();
                }
            });
            titleBox.add(this.refreshButton);
            this.add((Component)titleBox, "North");
        }
        this.add((Component)new JLabel(), "Center");
    }

    private void refreshName() {
        Object o = this.inspector.getObject();
        Class<?> clazz = o.getClass();
        String name = null;
        Class[] params = new Class[]{};
        try {
            name = (String)clazz.getMethod("getDisplayName", params).invoke(o, (Object[])params);
        }
        catch (Exception e) {
            try {
                name = (String)clazz.getMethod("getName", params).invoke(o, (Object[])params);
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        if (name == null) {
            String[] className = o.getClass().getName().split("[.]");
            name = className[className.length - 1] + "@" + o.hashCode();
        }
        if (this.refreshButton != null) {
            this.refreshButton.setText(name);
        }
    }

    public void refresh() {
        this.refreshName();
        this.inspector.refresh();
    }

    public void setObject(Object o) {
        this.setObject(o, Collections.EMPTY_SET);
    }

    public void setObject(Object o, Collection excludedPropertyNames) {
        this.object = o;
        if (this.inspector != null && o == this.inspector.getObject() && (excludedPropertyNames == null || excludedPropertyNames != null && ((Object)excludedPropertyNames).equals(this.inspector.getExcludedPropertyNames()))) {
            return;
        }
        if (o != null) {
            Inspector ip = null;
            Class<?> clazz = o.getClass();
            if (excludedPropertyNames == null || excludedPropertyNames.isEmpty()) {
                Inspector p = CLASS_TO_PANEL.get(clazz);
                if (p != null) {
                    ip = p;
                } else {
                    try {
                        ip = new Inspector(o, Collections.EMPTY_SET);
                        CLASS_TO_PANEL.put(clazz, ip);
                        ip.changeListener = this.changeListener;
                    }
                    catch (IntrospectionException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                try {
                    ip.setObject(o);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    ip = new Inspector(o, excludedPropertyNames);
                    ip.changeListener = this.changeListener;
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                    return;
                }
            }
            this.remove(this.refreshButton != null ? 1 : 0);
            this.add((Component)ip, "Center");
            this.inspector = ip;
            this.refreshName();
            this.revalidate();
            this.repaint();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.add(this.changeListener, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.remove(this.changeListener, listener);
    }

    public Object getObject() {
        return this.object;
    }
}

