/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -749512345261009514L;
    protected JList fontFamilyList_;
    protected FontStyleList fontStyleList_;
    protected JTextField fontSize_;
    protected JList fontSizeList_;
    protected PhraseCanvas phraseCanvas_;
    protected PublicChangeObservable observable_ = new PublicChangeObservable();
    protected int maxNumCharsInFontSize_ = 3;

    public FontSelectionPanel() {
        this((Font)null);
    }

    public FontSelectionPanel(Font initialFont) {
        this(initialFont, new String[]{"Plain", "Bold", "Italic", "Bold Italic"}, new int[]{8, 9, 10, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40, 48, 56, 64, 72});
    }

    public FontSelectionPanel(Font initialFont, String[] styleDisplayNames, int[] predefinedSizes) {
        super(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 11, 11));
        GridBagConstraints gbc = new GridBagConstraints();
        String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (initialFont == null) {
            initialFont = new Font(availableFontFamilyNames[0], 0, predefinedSizes[0]);
        }
        this.fontFamilyList_ = new JList<String>(availableFontFamilyNames);
        this.fontFamilyList_.setSelectionMode(0);
        this.fontFamilyList_.setVisibleRowCount(8);
        ListSelectionListener phraseCanvasUpdater = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FontSelectionPanel.this.observable_.setChanged();
                    FontSelectionPanel.this.observable_.notifyObservers();
                }
            }
        };
        this.fontFamilyList_.addListSelectionListener(phraseCanvasUpdater);
        gbc.fill = 1;
        gbc.gridheight = 2;
        this.add((Component)new JScrollPane(this.fontFamilyList_), gbc);
        this.fontStyleList_ = new FontStyleList(styleDisplayNames);
        this.fontStyleList_.setSelectionMode(0);
        this.fontStyleList_.setVisibleRowCount(4);
        this.fontStyleList_.addListSelectionListener(phraseCanvasUpdater);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        this.add((Component)new JScrollPane(this.fontStyleList_), gbc);
        this.fontSize_ = new JTextField();
        this.fontSize_.setHorizontalAlignment(4);
        this.fontSize_.setColumns(4);
        gbc.gridx = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        this.add((Component)this.fontSize_, gbc);
        this.fontSizeList_ = new JList<Integer>(this.validateAndConvertPredefinedSizes(predefinedSizes));
        this.fontSizeList_.setSelectionMode(0);
        this.fontSizeList_.setVisibleRowCount(1);
        this.fontSizeList_.setCellRenderer(new ListCellRenderer());
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 10, 0, 0);
        gbc.fill = 1;
        this.add((Component)new JScrollPane(this.fontSizeList_), gbc);
        this.phraseCanvas_ = new PhraseCanvas(initialFont.getFamily(), initialFont, Color.black);
        this.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                try {
                    FontSelectionPanel.this.phraseCanvas_.setPhrase((String)FontSelectionPanel.this.fontFamilyList_.getSelectedValue());
                    FontSelectionPanel.this.phraseCanvas_.setFont(FontSelectionPanel.this.getSelectedFont());
                }
                catch (InvalidFontException e) {
                    FontSelectionPanel.this.phraseCanvas_.setPhrase("");
                }
                FontSelectionPanel.this.phraseCanvas_.invalidate();
                FontSelectionPanel.this.phraseCanvas_.repaint();
            }
        });
        this.phraseCanvas_.setSize((int)this.getPreferredSize().getWidth(), 100);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 2;
        this.add((Component)new JScrollPane(this.phraseCanvas_), gbc);
        FontSizeSynchronizer fontSizeSynchronizer = new FontSizeSynchronizer(this.fontSizeList_, this.fontSize_);
        this.fontSizeList_.addListSelectionListener(fontSizeSynchronizer);
        this.fontSize_.getDocument().addDocumentListener(fontSizeSynchronizer);
        this.fontFamilyList_.setSelectedValue(initialFont.getFamily(), true);
        this.fontStyleList_.setSelectedStyle(initialFont.getStyle());
        this.fontSize_.setText(String.valueOf(initialFont.getSize()));
    }

    private Integer[] validateAndConvertPredefinedSizes(int[] predefinedSizes) {
        if (predefinedSizes == null) {
            throw new IllegalArgumentException("int[] predefinedSizes may not be null");
        }
        if (predefinedSizes.length < 1) {
            throw new IllegalArgumentException("int[] predefinedSizes must contain one or more values");
        }
        Integer[] predefinedSizeIntegers = new Integer[predefinedSizes.length];
        for (int i = 0; i < predefinedSizes.length; ++i) {
            if (predefinedSizes[i] < 1) {
                throw new IllegalArgumentException("int[] predefinedSizes may not contain integers with value less than 1");
            }
            predefinedSizeIntegers[i] = new Integer(predefinedSizes[i]);
        }
        return predefinedSizeIntegers;
    }

    public void addObserver(Observer o) {
        this.observable_.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observable_.deleteObserver(o);
    }

    public String getSelectedFontFamily() throws NoFontFamilySelectedException {
        String fontFamily = (String)this.fontFamilyList_.getSelectedValue();
        if (fontFamily == null) {
            throw new NoFontFamilySelectedException("No font family is currently selected");
        }
        return fontFamily;
    }

    public int getSelectedFontStyle() throws NoFontStyleSelectedException {
        return this.fontStyleList_.getSelectedStyle();
    }

    public int getSelectedFontSize() throws NoFontSizeSpecifiedException, InvalidFontSizeException {
        String fontSize = this.fontSize_.getText();
        if (fontSize == null || fontSize.equals("")) {
            throw new NoFontSizeSpecifiedException("No font size specified");
        }
        if (fontSize.length() > this.maxNumCharsInFontSize_) {
            throw new InvalidFontSizeException("Too many characters in font size");
        }
        try {
            return Integer.parseInt(fontSize);
        }
        catch (NumberFormatException e) {
            throw new InvalidFontSizeException("The number specified in the font size text field (" + this.fontSize_.getText() + ") is not a valid integer.");
        }
    }

    public Font getSelectedFont() throws InvalidFontException {
        return new Font(this.getSelectedFontFamily(), this.getSelectedFontStyle(), this.getSelectedFontSize());
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            return;
        }
        this.setSelectedFontFamily(font.getFamily());
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public void setSelectedFontFamily(String family) {
        ListModel familyListModel = this.fontFamilyList_.getModel();
        for (int i = 0; i < familyListModel.getSize(); ++i) {
            String s = familyListModel.getElementAt(i).toString();
            if (!s.equalsIgnoreCase(family)) continue;
            this.fontFamilyList_.setSelectedIndex(i);
            this.fontFamilyList_.ensureIndexIsVisible(i);
            return;
        }
        throw new IllegalArgumentException("The font family supplied, '" + family + "', is not in the list of availalbe " + "font families.");
    }

    public void setSelectedFontStyle(int style) {
        this.fontStyleList_.setSelectedStyle(style);
    }

    public void setSelectedFontSize(int size) {
        this.fontSize_.setText(String.valueOf(size));
    }

    public static class InvalidFontSizeException
    extends InvalidFontException {
        private static final long serialVersionUID = 4587112613484830331L;

        public InvalidFontSizeException(String msg) {
            super(msg);
        }
    }

    public static class NoFontSizeSpecifiedException
    extends InvalidFontException {
        private static final long serialVersionUID = -6143153491591076357L;

        public NoFontSizeSpecifiedException(String msg) {
            super(msg);
        }
    }

    public static class NoFontStyleSelectedException
    extends InvalidFontException {
        private static final long serialVersionUID = 7520458647791842774L;

        public NoFontStyleSelectedException(String msg) {
            super(msg);
        }
    }

    public static class NoFontFamilySelectedException
    extends InvalidFontException {
        private static final long serialVersionUID = -6625954189383165101L;

        public NoFontFamilySelectedException(String msg) {
            super(msg);
        }
    }

    public static class InvalidFontException
    extends Exception {
        private static final long serialVersionUID = -974409847569242299L;

        public InvalidFontException(String msg) {
            super(msg);
        }
    }

    public static class PhraseCanvas
    extends Canvas {
        private static final long serialVersionUID = -4353099178877517679L;
        protected String phrase_;
        protected Font font_;
        protected Color color_;
        protected boolean antialiasOn_;

        public PhraseCanvas(String phrase, Font font, Color color) {
            this.phrase_ = phrase;
            this.font_ = font;
            this.color_ = color;
        }

        public void paint(Graphics g) {
            Font dummyFont = new Font(this.font_.getFamily(), this.font_.getStyle(), this.font_.getSize() + 1);
            dummyFont.createGlyphVector(new FontRenderContext(null, this.antialiasOn_, false), this.phrase_);
            GlyphVector glyphVector = this.font_.createGlyphVector(new FontRenderContext(null, this.antialiasOn_, false), this.phrase_);
            Rectangle2D logicalBounds = glyphVector.getLogicalBounds();
            double x = logicalBounds.getWidth() < (double)this.getWidth() ? (double)(this.getWidth() / 2) - logicalBounds.getWidth() / 2.0 : 0.0;
            double y = logicalBounds.getHeight() < (double)this.getHeight() ? (double)(this.getHeight() / 2) + logicalBounds.getHeight() / 2.0 : (double)this.getHeight();
            g.setColor(this.color_);
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawGlyphVector(glyphVector, (float)x, (float)y);
        }

        public String getPhrase() {
            return this.phrase_;
        }

        public void setPhrase(String phrase) {
            this.phrase_ = phrase;
        }

        public Font getFont() {
            return this.font_;
        }

        public void setFont(Font font) {
            this.font_ = font;
        }

        public Color getColor() {
            return this.color_;
        }

        public void setColor(Color color) {
            this.color_ = color;
        }

        public boolean isAntialiasOn() {
            return this.antialiasOn_;
        }

        public void setAntialiasOn(boolean antialiasOn) {
            this.antialiasOn_ = antialiasOn;
        }
    }

    protected static class PublicChangeObservable
    extends Observable {
        protected PublicChangeObservable() {
        }

        public void setChanged() {
            super.setChanged();
        }
    }

    protected static class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -2133548379487854848L;

        protected ListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalAlignment(4);
            return label;
        }
    }

    protected static class FontStyleList
    extends JList {
        private static final long serialVersionUID = -1327535082843448406L;

        public FontStyleList(String[] styleDisplayNames) {
            super(FontStyleList.validateStyleDisplayNames(styleDisplayNames));
        }

        private static String[] validateStyleDisplayNames(String[] styleDisplayNames) {
            if (styleDisplayNames == null) {
                throw new IllegalArgumentException("String[] styleDisplayNames may not be null");
            }
            if (styleDisplayNames.length != 4) {
                throw new IllegalArgumentException("String[] styleDisplayNames must have a length of 4");
            }
            for (int i = 0; i < styleDisplayNames.length; ++i) {
                if (styleDisplayNames[i] != null) continue;
                throw new IllegalArgumentException("No member of String[] styleDisplayNames may be null");
            }
            return styleDisplayNames;
        }

        public int getSelectedStyle() throws NoFontStyleSelectedException {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new NoFontStyleSelectedException("No font style is currently selected");
        }

        public void setSelectedStyle(int style) {
            switch (style) {
                case 0: {
                    this.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.setSelectedIndex(3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("int style must come from java.awt.Font");
                }
            }
        }
    }

    protected class FontSizeSynchronizer
    implements DocumentListener,
    ListSelectionListener {
        protected JList list_;
        protected JTextField textField_;
        protected boolean updating_;

        public FontSizeSynchronizer(JList list, JTextField textField) {
            this.list_ = list;
            this.textField_ = textField;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this.updating_) {
                return;
            }
            this.updating_ = true;
            if (!e.getValueIsAdjusting()) {
                Object selectedValue = ((JList)e.getSource()).getSelectedValue();
                if (selectedValue != null) {
                    this.textField_.setText(selectedValue.toString());
                }
                FontSelectionPanel.this.observable_.setChanged();
                FontSelectionPanel.this.observable_.notifyObservers();
            }
            this.updating_ = false;
        }

        public void changedUpdate(DocumentEvent e) {
            this.handle(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.handle(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.handle(e);
        }

        protected void handle(DocumentEvent e) {
            if (this.updating_) {
                return;
            }
            this.updating_ = true;
            try {
                Integer currentFontSizeInteger = Integer.valueOf(this.textField_.getText());
                boolean currentSizeWasInList = false;
                for (int i = 0; i < this.list_.getModel().getSize(); ++i) {
                    Object listMember = this.list_.getModel().getElementAt(i);
                    if (!listMember.equals(currentFontSizeInteger)) continue;
                    this.list_.setSelectedValue(currentFontSizeInteger, true);
                    currentSizeWasInList = true;
                    break;
                }
                if (!currentSizeWasInList) {
                    this.list_.clearSelection();
                }
            }
            catch (NumberFormatException nfe) {
                this.list_.clearSelection();
            }
            FontSelectionPanel.this.observable_.setChanged();
            FontSelectionPanel.this.observable_.notifyObservers();
            this.updating_ = false;
        }
    }
}

