/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.beans.PropertyEditorSupport;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class EditorSpawner
extends PropertyEditorSupport {
    private static String nameOfNull = "null";
    private Box panel;
    private JButton button;
    JButton nullButton;
    private Object storedValue;
    private boolean nullAllowed;
    private static String nameOfCreation = "create ...";
    private Icon icon = new Icon(){

        public void paintIcon(Component cmp, Graphics g, int x, int y) {
            if (EditorSpawner.this.getValue() != null) {
                EditorSpawner.this.paintEditedObject(cmp, g, x, y);
            } else {
                EditorSpawner.this.paintText(null, nameOfCreation, cmp, g, x, y);
            }
        }

        public int getIconWidth() {
            return EditorSpawner.this.getIconWidth();
        }

        public int getIconHeight() {
            return EditorSpawner.this.getIconHeight();
        }
    };

    public EditorSpawner(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
        this.panel = new Box(0);
        this.button = new JButton();
        this.button.setMaximumSize(new Dimension(32000, 25));
        this.button.setPreferredSize(new Dimension(50, 25));
        this.button.setMargin(new Insets(2, 2, 2, 2));
        this.button.setIcon(this.icon);
        this.button.setFocusable(false);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorSpawner.this.spawnDialog();
            }
        });
        this.panel.add(this.button);
        if (nullAllowed) {
            this.nullButton = new JButton(nameOfNull);
            this.nullButton.setMargin(new Insets(2, 2, 2, 2));
            this.nullButton.setMaximumSize(new Dimension(60, 25));
            this.nullButton.setForeground(Color.red);
            this.nullButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    EditorSpawner.this.setValue(null);
                }
            });
        }
    }

    private void spawnDialog() {
        this.storedValue = this.getValue();
        AbstractDialog dialog = this.getDialog();
        dialog.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                EditorSpawner.this.setValueFromDialog();
            }
        });
        dialog.setOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditorSpawner.this.setValue(EditorSpawner.this.getDialog().getValue());
            }
        });
        dialog.setCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditorSpawner.this.setValue(EditorSpawner.this.storedValue);
            }
        });
        dialog.setValue(this.getValue());
        dialog.show(this.button);
    }

    private void setValueFromDialog() {
        Object o = this.getDialog().getValue();
        if (this.nullAllowed) {
            if (o != null && this.getValue() == null) {
                this.panel.add(this.nullButton);
                this.panel.validate();
            }
            if (o == null && this.getValue() != null) {
                this.panel.remove(this.nullButton);
                this.panel.validate();
            }
        }
        this.button.repaint();
        super.setValue(this.getDialog().getValue());
    }

    public void setValue(Object o) {
        if (this.nullAllowed) {
            if (o != null && this.getValue() == null) {
                this.panel.add(this.nullButton);
                this.panel.validate();
            }
            if (o == null && this.getValue() != null) {
                this.panel.remove(this.nullButton);
                this.panel.validate();
            }
        }
        if (o != null) {
            this.getDialog().setValue(o);
        } else {
            this.getDialog().close();
        }
        this.button.repaint();
        super.setValue(o);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.panel;
    }

    public abstract AbstractDialog getDialog();

    public int getIconWidth() {
        return 32;
    }

    public int getIconHeight() {
        return 16;
    }

    protected abstract void paintEditedObject(Component var1, Graphics var2, int var3, int var4);

    protected void paintText(Font font, String text, Component cmp, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.black);
        if (font == null) {
            font = this.button.getFont();
        }
        TextLayout tl = new TextLayout(text, font, g2d.getFontRenderContext());
        Rectangle r = tl.getBounds().getBounds();
        int height = r.height;
        int width = r.width;
        int w = (this.getIconWidth() - width) / 2;
        int h = (this.getIconHeight() - height) / 2;
        g2d.setFont(font);
        g2d.drawString(text, x + w, y + height + h);
    }

    protected void repaintIcon() {
        this.button.repaint();
    }

    public static String getNameOfNull() {
        return nameOfNull;
    }

    public static void setNameOfNull(String nameOfNull) {
        EditorSpawner.nameOfNull = nameOfNull;
    }

    public static String getNameOfCreation() {
        return nameOfCreation;
    }

    public static void setNameOfCreation(String nameOfCreation) {
        EditorSpawner.nameOfCreation = nameOfCreation;
    }
}

