/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class ClassUtils {
    public static URLClassLoader getURLClassLoader(IResource iResource) throws MalformedURLException {
        IJavaElement iJavaElement = ClassUtils.getJavaElement(iResource);
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        URL[] uRLArray = ClassUtils.getPasserelleClassPath(iJavaProject);
        return ClassUtils.getURLClassLoader(uRLArray);
    }

    public static URLClassLoader getURLClassLoader(URL[] uRLArray) throws MalformedURLException {
        return new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
    }

    public static URL[] getPasserelleClassPath(IJavaProject iJavaProject) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        if (iJavaProject != null) {
            arrayList.addAll(ClassUtils.getProjectClassPathPaths(iJavaProject));
        }
        IPath[] iPathArray = arrayList.toArray(new IPath[arrayList.size()]);
        try {
            return ClassUtils.getRawLocationsURLForResources(iPathArray);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static List<IPath> getProjectClassPathPaths(IJavaProject iJavaProject) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        try {
            IClasspathEntry iClasspathEntry;
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            if (iClasspathEntryArray != null) {
                int n = 0;
                while (n < iClasspathEntryArray.length) {
                    iClasspathEntry = iClasspathEntryArray[n];
                    if (iClasspathEntry.getEntryKind() == 1) {
                        IPath iPath = iClasspathEntry.getPath();
                        arrayList.add(iPath);
                    }
                    ++n;
                }
            }
            IPath iPath = ClassUtils.getProjectLocation(iJavaProject.getProject());
            iClasspathEntry = iPath.append(iJavaProject.getOutputLocation().removeFirstSegments(1));
            arrayList.add((IPath)iClasspathEntry);
        }
        catch (JavaModelException javaModelException) {}
        return arrayList;
    }

    public static URL getRawLocationURL(IPath iPath) throws MalformedURLException {
        File file = ClassUtils.getRawLocationFile(iPath);
        return file.toURL();
    }

    public static String getRawLocation(IPath iPath) throws MalformedURLException {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (iResource != null) {
            IPath iPath2 = iResource.getRawLocation();
            if (iPath2 == null && (iPath2 = iResource.getLocation()) == null) {
                throw new RuntimeException("Could not determine physical location for " + iPath);
            }
            return iPath2.toOSString();
        }
        return iPath.makeAbsolute().toOSString();
    }

    public static File getRawLocationFile(IPath iPath) {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        File file = null;
        if (iResource != null) {
            IPath iPath2 = iResource.getRawLocation();
            if (iPath2 == null && (iPath2 = iResource.getLocation()) == null) {
                throw new RuntimeException("Could not determine physical location for " + iPath);
            }
            file = iPath2.toFile();
        } else {
            file = iPath.toFile();
        }
        return file;
    }

    public static IPath getProjectLocation(IProject iProject) {
        if (iProject.getRawLocation() == null) {
            return iProject.getLocation();
        }
        return iProject.getRawLocation();
    }

    public static URL[] getRawLocationsURLForResources(IPath[] iPathArray) throws MalformedURLException {
        URL[] uRLArray = new URL[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            uRLArray[n] = ClassUtils.getRawLocationURL(iPathArray[n]);
            ++n;
        }
        return uRLArray;
    }

    public static String[] getRawLocationsForResources(IPath[] iPathArray) throws MalformedURLException {
        String[] stringArray = new String[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            stringArray[n] = ClassUtils.getRawLocation(iPathArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static IJavaElement getJavaElement(IResource iResource) {
        if (iResource != null) {
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
            if (iJavaElement == null) {
                IProject iProject = iResource.getProject();
                iJavaElement = JavaCore.create((IProject)iProject);
            }
            if (iJavaElement != null) {
                return iJavaElement;
            }
        }
        return null;
    }

    public static IPath[] buildProjectClasspath(ILaunchConfiguration iLaunchConfiguration, IJavaProject iJavaProject) throws CoreException, MalformedURLException {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        if (iJavaProject != null) {
            arrayList.addAll(ClassUtils.getProjectClassPathPaths(iJavaProject));
        }
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)iLaunchConfiguration);
        iRuntimeClasspathEntryArray = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])iRuntimeClasspathEntryArray, (ILaunchConfiguration)iLaunchConfiguration);
        int n = 0;
        while (n < iRuntimeClasspathEntryArray.length) {
            String string;
            if (iRuntimeClasspathEntryArray[n].getClasspathProperty() == 3 && (string = iRuntimeClasspathEntryArray[n].getLocation()) != null) {
                arrayList.add(iRuntimeClasspathEntryArray[n].getPath());
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }
}

