/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.launch;

import com.isencia.passerelle.workbench.model.launch.ModelLauncher;
import com.isencia.passerelle.workbench.model.ui.utils.LaunchUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.osgi.framework.Version;

public class LaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String APPLICATION_NAME = "com.isencia.passerelle.workbench.model.launch";
    private String workspaceLocation;
    protected File configDir = null;
    private Map<String, IPluginModelBase> bundles;
    private Map pluginModels;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MessageFormat.format("{0}...", iLaunchConfiguration.getName()), 5);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        try {
            string = "run";
            try {
                this.preLaunchCheck(iLaunchConfiguration, iLaunch, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getSeverity() != 8) throw coreException;
                iProgressMonitor.setCanceled(true);
                iProgressMonitor.done();
                return;
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IVMRunner iVMRunner = this.getVMRunner(iLaunchConfiguration, string);
            File file = this.verifyWorkingDirectory(iLaunchConfiguration);
            String string2 = null;
            if (file != null) {
                string2 = file.getAbsolutePath();
            }
            String[] stringArray = this.getEnvironment(iLaunchConfiguration);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.collectExecutionArguments(iLaunchConfiguration, arrayList, arrayList2);
            Map<String, String> map = this.getVMSpecificAttributesMap(iLaunchConfiguration);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Map.Entry<String, IPluginModelBase> entry : this.bundles.entrySet()) {
                IPluginModelBase iPluginModelBase = entry.getValue();
                arrayList3.add(iPluginModelBase.getInstallLocation());
            }
            VMRunnerConfiguration vMRunnerConfiguration = new VMRunnerConfiguration(ModelLauncher.class.getName(), arrayList3.toArray(new String[0]));
            vMRunnerConfiguration.setVMArguments(arrayList.toArray(new String[arrayList.size()]));
            vMRunnerConfiguration.setProgramArguments(arrayList2.toArray(new String[arrayList2.size()]));
            vMRunnerConfiguration.setEnvironment(stringArray);
            vMRunnerConfiguration.setWorkingDirectory(string2);
            vMRunnerConfiguration.setVMSpecificAttributesMap(map);
            vMRunnerConfiguration.setBootClassPath(this.getBootpath(iLaunchConfiguration));
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            iProgressMonitor.worked(1);
            this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
            iProgressMonitor.worked(1);
            iVMRunner.run(vMRunnerConfiguration, iLaunch, iProgressMonitor);
            if (!iProgressMonitor.isCanceled()) return;
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IVMRunner getVMRunner(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        IVMInstall iVMInstall = VMHelper.createLauncher((ILaunchConfiguration)iLaunchConfiguration);
        return iVMInstall.getVMRunner(string);
    }

    protected void abort(String string, Throwable throwable, int n) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", n, string, throwable));
    }

    protected void collectExecutionArguments(ILaunchConfiguration iLaunchConfiguration, List list, List list2) throws CoreException {
        Object object;
        String string = this.getProgramArguments(iLaunchConfiguration);
        String string2 = this.getVMArguments(iLaunchConfiguration);
        ExecutionArguments executionArguments = new ExecutionArguments(string2, string);
        list.addAll(Arrays.asList(executionArguments.getVMArgumentsArray()));
        list2.addAll(Arrays.asList(executionArguments.getProgramArgumentsArray()));
        list2.add("-clean");
        String string3 = LaunchConfigurationHelper.getProductID((ILaunchConfiguration)iLaunchConfiguration);
        String string4 = LaunchConfigurationHelper.getContributingPlugin((String)string3);
        TargetPlatform.createPlatformConfiguration((File)this.getConfigurationDirectory(iLaunchConfiguration), (IPluginModelBase[])this.bundles.values().toArray(new IPluginModelBase[this.bundles.size()]), string4 != null ? this.bundles.get(string4) : null);
        TargetPlatformHelper.checkPluginPropertiesConsistency(this.bundles, (File)this.getConfigurationDirectory(iLaunchConfiguration));
        list2.add("-configuration");
        list2.add("file:" + new Path(this.getConfigurationDirectory(iLaunchConfiguration).getPath()).addTrailingSeparator().toString());
        IPluginModelBase iPluginModelBase = this.findPlugin("org.eclipse.pde.core");
        if (iPluginModelBase != null && VersionUtil.compareMacroMinorMicro((Version)iPluginModelBase.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) < 0) {
            list2.add("-pdelaunch");
        }
        if (iLaunchConfiguration.getAttribute("tracing", false) && !"[NONE]".equals(iLaunchConfiguration.getAttribute("checked", null))) {
            list2.add("-debug");
            object = String.valueOf(this.getConfigurationDirectory(iLaunchConfiguration).getPath()) + '/' + ".options";
            list2.add(LaunchArgumentsHelper.getTracingFileArgument((ILaunchConfiguration)iLaunchConfiguration, (String)object));
        }
        object = LaunchArgumentsHelper.getUserProgramArgumentArray((ILaunchConfiguration)iLaunchConfiguration);
        int n = 0;
        while (n < ((String[])object).length) {
            if (!object[n].equals("-debug") || !list2.contains("-debug")) {
                list2.add(object[n]);
            }
            ++n;
        }
        if (!iLaunchConfiguration.getAttribute("append.args", false)) {
            if (!list2.contains("-os")) {
                list2.add("-os");
                list2.add(TargetPlatform.getOS());
            }
            if (!list2.contains("-ws")) {
                list2.add("-ws");
                list2.add(TargetPlatform.getWS());
            }
            if (!list2.contains("-arch")) {
                list2.add("-arch");
                list2.add(TargetPlatform.getOSArch());
            }
        }
    }

    private IPluginModelBase findPlugin(String string) throws CoreException {
        IPluginModelBase iPluginModelBase = PluginRegistry.findModel((String)string);
        if (iPluginModelBase == null) {
            iPluginModelBase = PDECore.getDefault().findPluginInHost(string);
        }
        if (iPluginModelBase == null) {
            this.abort(NLS.bind((String)PDEUIMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)string), null, 0);
        }
        return iPluginModelBase;
    }

    public String getProgramArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return LaunchArgumentsHelper.getUserProgramArguments((ILaunchConfiguration)iLaunchConfiguration);
    }

    public String getVMArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string;
        String string2 = LaunchArgumentsHelper.getUserVMArguments((ILaunchConfiguration)iLaunchConfiguration);
        if (this.workspaceLocation == null || this.workspaceLocation.length() == 0) {
            this.workspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)iLaunchConfiguration);
        }
        string2 = this.workspaceLocation.length() > 0 ? this.concatArg(string2, "-Dosgi.instance.area=" + this.workspaceLocation) : this.concatArg(string2, "-Dosgi.instance.area=" + LaunchUtils.findOsgiInstanceArea());
        string2 = this.concatArg(string2, "-Dosgi.install.area=" + LaunchUtils.findOsgiInstallArea());
        String[] stringArray = this.getRequiredPLugins();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray2[n2];
            IPluginModelBase iPluginModelBase = PluginRegistry.findModel((String)string);
            if (iPluginModelBase != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("file:/" + iPluginModelBase.getInstallLocation().replace(File.separatorChar, '/'));
            }
            ++n2;
        }
        string2 = this.concatArg(string2, "-Dosgi.framework.extensions=" + stringBuffer);
        string2 = this.concatArg(string2, "-Dosgi.framework.useSystemProperties=false");
        string2 = this.concatArg(string2, "-Declipse.application=com.isencia.passerelle.workbench.model.launch");
        string2 = this.concatArg(string2, "-Dosgi.frameworkParentClassloader=current");
        string = LaunchUtils.getModelFileName(iLaunchConfiguration);
        if (string != null) {
            string2 = this.concatArg(string2, "-Dmodel=" + string);
        }
        return string2;
    }

    private String concatArg(String string, String string2) {
        if (string.length() > 0 && !string.endsWith(" ")) {
            string = string.concat(" ");
        }
        return string.concat(string2);
    }

    public String[] getEnvironment(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
    }

    public File getWorkingDirectory(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory((ILaunchConfiguration)iLaunchConfiguration);
    }

    public Map<String, String> getVMSpecificAttributesMap(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap((ILaunchConfiguration)iLaunchConfiguration);
    }

    protected void setDefaultSourceLocator(ILaunch iLaunch, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
        iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
        String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(string)) {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            iLaunchConfigurationWorkingCopy.doSave();
        }
        this.manageLaunch(iLaunch);
    }

    protected File getConfigurationDirectory(ILaunchConfiguration iLaunchConfiguration) {
        if (this.configDir == null) {
            this.configDir = LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)iLaunchConfiguration);
        }
        return this.configDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects((ILaunchConfiguration)iLaunchConfiguration));
    }

    protected void manageLaunch(ILaunch iLaunch) {
        PDEPlugin.getDefault().getLaunchListener().manage(iLaunch);
    }

    protected void preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        this.workspaceLocation = null;
        this.pluginModels = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)iLaunchConfiguration, (boolean)false);
        this.bundles = new HashMap<String, IPluginModelBase>(this.pluginModels.size());
        for (IPluginModelBase iPluginModelBase : this.pluginModels.keySet()) {
            this.bundles.put(iPluginModelBase.getPluginBase().getId(), iPluginModelBase);
        }
        boolean bl = iLaunchConfiguration.getAttribute("automaticValidate", false);
        iProgressMonitor.beginTask("", bl ? 3 : 4);
        if (bl) {
            this.validatePluginDependencies(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        this.validateProjectDependencies(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.clear(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iLaunch.setAttribute("configLocation", this.getConfigurationDirectory(iLaunchConfiguration).toString());
    }

    protected void clear(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.workspaceLocation == null) {
            this.workspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)iLaunchConfiguration);
        }
        if (!LauncherUtils.clearWorkspace((ILaunchConfiguration)iLaunchConfiguration, (String)this.workspaceLocation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        if (iLaunchConfiguration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigurationDirectory(iLaunchConfiguration));
        }
    }

    protected void validateProjectDependencies(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) {
        LauncherUtils.validateProjectDependencies((ILaunchConfiguration)iLaunchConfiguration, (IProgressMonitor)iProgressMonitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        EclipsePluginValidationOperation eclipsePluginValidationOperation = new EclipsePluginValidationOperation(iLaunchConfiguration);
        LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)eclipsePluginValidationOperation, (IProgressMonitor)iProgressMonitor);
    }

    protected String[] getRequiredPLugins() {
        return new String[]{"com.isencia.passerelle.workbench.logging.production", "com.isencia.passerelle.workbench.logging.development", "com.isencia.passerelle.workbench.model", "com.isencia.passerelle.actor", "com.isencia.passerelle.engine", "com.isencia.passerelle.engine.api", "com.isencia.passerelle.commons", "com.isencia.passerelle.ume", "ptolemy.domains.and.actors", "ptolemy.gui", "diva"};
    }
}

