/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.command;

import com.isencia.passerelle.workbench.model.ui.ComponentUtility;
import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.command.CreateConnectionCommand;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class DeleteComponentCommand
extends Command {
    private IPasserelleMultiPageEditor multiPageEditor;
    private List<Integer> indexList = new ArrayList<Integer>();
    private static Logger logger = LoggerFactory.getLogger(DeleteComponentCommand.class);
    private NamedObj container;
    private NamedObj child;
    private CompositeEntity parent;
    private int vAlign;
    private int hAlign;
    private List<Command> delecteConnectionCommands = new ArrayList<Command>();

    public void setMultiPageEditor(IPasserelleMultiPageEditor iPasserelleMultiPageEditor) {
        this.multiPageEditor = iPasserelleMultiPageEditor;
    }

    public void addIndex(Integer n) {
        this.indexList.add(n);
    }

    public void emptyIndexList() {
        this.indexList.removeAll(this.indexList);
    }

    public DeleteComponentCommand() {
        super("Delete");
    }

    public Logger getLogger() {
        return logger;
    }

    public void execute() {
        this.doExecute();
    }

    protected void doExecute() {
        this.parent.requestChange((ChangeRequest)new ModelChangeRequest(((Object)((Object)this)).getClass(), this.parent, "delete", this.child){

            protected void _execute() throws Exception {
                if (DeleteComponentCommand.this.child instanceof Vertex) {
                    Vertex vertex = (Vertex)DeleteComponentCommand.this.child;
                    ((TypedIORelation)vertex.getContainer()).setContainer(null);
                    DeleteComponentCommand.this.container = ((TypedIORelation)vertex.getContainer()).getContainer();
                } else {
                    DeleteComponentCommand.this.delecteConnectionCommands = ComponentUtility.deleteConnections(DeleteComponentCommand.this.child);
                    DeleteComponentCommand.this.container = DeleteComponentCommand.this.child.getContainer();
                    ComponentUtility.setContainer(DeleteComponentCommand.this.child, null);
                    for (Integer n : DeleteComponentCommand.this.indexList) {
                        Comparator comparator = Collections.reverseOrder();
                        Collections.sort(DeleteComponentCommand.this.indexList, comparator);
                        DeleteComponentCommand.this.multiPageEditor.removePage(n);
                    }
                }
            }
        });
    }

    public void redo() {
        this.doExecute();
    }

    private void restoreConnections(NamedObj namedObj) {
        for (Command command : this.delecteConnectionCommands) {
            command.undo();
        }
    }

    private void restoreRelation(NamedObj namedObj, List list, List list2) {
        try {
            if (!list2.isEmpty() && !list.isEmpty()) {
                CreateConnectionCommand createConnectionCommand = new CreateConnectionCommand((NamedObj)((ComponentPort)list2.get(0)), (NamedObj)((ComponentPort)list.get(0)), this.multiPageEditor);
                createConnectionCommand.setContainer(this.parent);
                createConnectionCommand.execute();
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to delete targetConnection", (Throwable)exception);
        }
    }

    private ComponentPort searchPort(Enumeration enumeration, NamedObj namedObj) {
        while (enumeration.hasMoreElements()) {
            IOPort iOPort = (IOPort)enumeration.nextElement();
            iOPort.getName();
            iOPort.getContainer();
            if (!(namedObj instanceof ComponentEntity)) continue;
            ComponentEntity componentEntity = (ComponentEntity)namedObj;
            for (Object e : componentEntity.portList()) {
                Port port = (Port)e;
                if (!port.getName().equals(iOPort.getName()) || !(port instanceof ComponentPort)) continue;
                return (ComponentPort)port;
            }
        }
        return null;
    }

    public void setChild(NamedObj namedObj) {
        this.child = namedObj;
    }

    public void setParent(CompositeEntity compositeEntity) {
        this.parent = compositeEntity;
    }

    public void undo() {
        this.parent.requestChange(new ChangeRequest(this.child, "undo-delete"){

            protected void _execute() throws Exception {
                try {
                    if (DeleteComponentCommand.this.child instanceof Vertex) {
                        Vertex vertex = (Vertex)DeleteComponentCommand.this.child;
                        ((TypedIORelation)vertex.getContainer()).setContainer((CompositeEntity)DeleteComponentCommand.this.container);
                    } else {
                        ComponentUtility.setContainer(DeleteComponentCommand.this.child, DeleteComponentCommand.this.container);
                        DeleteComponentCommand.this.restoreConnections(DeleteComponentCommand.this.child);
                    }
                }
                catch (Exception exception) {
                    DeleteComponentCommand.this.getLogger().error("Unable to undo deletion of component", (Throwable)exception);
                }
            }
        });
    }
}

