/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.SelectionStrategy;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.util.ObjectUtil;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class GIOPConnectionManager
implements Configurable {
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private List server_giop_connections = new LinkedList();
    private int max_server_giop_connections = 0;
    private Class statistics_provider_class = null;
    private SelectionStrategy selection_strategy = null;
    private int wait_for_idle_interval = 0;

    public void configure(Configuration configuration) throws ConfigurationException {
        block3: {
            this.configuration = (org.jacorb.config.Configuration)configuration;
            this.logger = this.configuration.getNamedLogger("jacorb.orb.giop.conn");
            this.max_server_giop_connections = this.configuration.getAttributeAsInteger("jacorb.connection.max_server_connections", Integer.MAX_VALUE);
            this.selection_strategy = (SelectionStrategy)this.configuration.getAttributeAsObject("jacorb.connection.selection_strategy_class");
            this.wait_for_idle_interval = this.configuration.getAttributeAsInteger("jacorb.connection.wait_for_idle_interval", 500);
            String string = this.configuration.getAttribute("jacorb.connection.statistics_provider_class", "");
            if (string.length() > 0) {
                try {
                    this.statistics_provider_class = ObjectUtil.classForName(string);
                }
                catch (Exception exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGIOPConnection createServerGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener) {
        List list;
        ServerGIOPConnection serverGIOPConnection;
        block17: {
            if (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                if (this.selection_strategy != null) {
                    while (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                        serverGIOPConnection = null;
                        list = this.server_giop_connections;
                        synchronized (list) {
                            serverGIOPConnection = this.selection_strategy.selectForClose(this.server_giop_connections);
                        }
                        if (serverGIOPConnection == null || !serverGIOPConnection.tryClose()) {
                            try {
                                Thread.sleep(this.wait_for_idle_interval);
                            }
                            catch (Exception exception) {
                                if (!this.logger.isWarnEnabled()) continue;
                                this.logger.warn("During thread.sleep: " + exception.getMessage());
                            }
                            continue;
                        }
                        break;
                    }
                } else if (this.logger.isErrorEnabled()) {
                    this.logger.error("No. of max server giop connections set, but no SelectionStrategy present");
                }
            }
            serverGIOPConnection = new ServerGIOPConnection(profile, connection, requestListener, replyListener, this.getStatisticsProvider(), this);
            try {
                serverGIOPConnection.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isWarnEnabled()) break block17;
                this.logger.warn("ConfigurationException", configurationException);
            }
        }
        list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.add(serverGIOPConnection);
        }
        return serverGIOPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServerGIOPConnection(ServerGIOPConnection serverGIOPConnection) {
        List list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.remove(serverGIOPConnection);
        }
    }

    public GIOPConnection createClientGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener) {
        ClientGIOPConnection clientGIOPConnection;
        block2: {
            clientGIOPConnection = new ClientGIOPConnection(profile, connection, requestListener, replyListener, null);
            try {
                clientGIOPConnection.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("ConfigurationException", configurationException);
            }
        }
        return clientGIOPConnection;
    }

    private StatisticsProvider getStatisticsProvider() {
        StatisticsProvider statisticsProvider;
        block3: {
            statisticsProvider = null;
            if (this.statistics_provider_class != null) {
                try {
                    statisticsProvider = (StatisticsProvider)this.statistics_provider_class.newInstance();
                }
                catch (Exception exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create instance from Class >" + this.statistics_provider_class + '<');
                }
            }
        }
        return statisticsProvider;
    }
}

