/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class ParsedIOR {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Profile effectiveProfile = null;
    private List profiles = new ArrayList();
    private TaggedComponentList components = new TaggedComponentList();
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private ORB orb = null;
    private CodeSetComponentInfo cs_info = null;
    private Integer orbTypeId = null;
    private Logger logger;
    static /* synthetic */ Class class$org$omg$CONV_FRAME$CodeSetComponentInfoHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jacorb$orb$ParsedIOR$LongHelper;
    static /* synthetic */ Class class$org$jacorb$orb$ParsedIOR$StringHelper;

    public static IOR createObjectIOR(Profile profile) {
        String string = "IDL:omg.org/CORBA/Object:1.0";
        TaggedComponentList taggedComponentList = new TaggedComponentList();
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        cDROutputStream.write_long(1245790976);
        taggedComponentList.addComponent(new TaggedComponent(0, cDROutputStream.getBufferCopy()));
        ArrayList<TaggedProfile> arrayList = new ArrayList<TaggedProfile>();
        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
        TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
        taggedComponentSeqHolder.value = taggedComponentList.asArray();
        profile.marshal(taggedProfileHolder, taggedComponentSeqHolder);
        arrayList.add(taggedProfileHolder.value);
        TaggedProfile[] taggedProfileArray = new TaggedProfile[arrayList.size()];
        arrayList.toArray(taggedProfileArray);
        return new IOR(string, taggedProfileArray);
    }

    public static byte[] extractObjectKey(TargetAddress targetAddress, ORB oRB) {
        java.lang.Object object;
        TaggedProfile taggedProfile = null;
        switch (targetAddress.discriminator()) {
            case 0: {
                return targetAddress.object_key();
            }
            case 1: {
                taggedProfile = new TaggedProfile(targetAddress.profile().tag, targetAddress.profile().profile_data);
                break;
            }
            case 2: {
                object = targetAddress.ior();
                taggedProfile = new TaggedProfile(((IORAddressingInfo)object).ior.profiles[((IORAddressingInfo)object).selected_profile_index].tag, ((IORAddressingInfo)object).ior.profiles[((IORAddressingInfo)object).selected_profile_index].profile_data);
            }
        }
        object = new TaggedProfileHolder(taggedProfile);
        Factories factories = oRB.getTransportManager().getFactories(taggedProfile.tag);
        if (factories != null) {
            return factories.demarshal_profile((TaggedProfileHolder)object, new TaggedComponentSeqHolder()).get_object_key();
        }
        return null;
    }

    public String getCodebaseComponent() {
        return this.getStringComponent(25);
    }

    public ParsedIOR(String string, org.omg.CORBA.ORB oRB, Logger logger) throws IllegalArgumentException {
        if (!(oRB instanceof ORB)) {
            throw new IllegalArgumentException("Construct ParsedIOR with full ORB not Singleton");
        }
        this.orb = (ORB)oRB;
        this.parse(string);
        this.logger = logger;
    }

    public ParsedIOR(String string, ORB oRB, Logger logger) throws IllegalArgumentException {
        this.orb = oRB;
        this.logger = logger;
        this.parse(string);
    }

    public ParsedIOR(IOR iOR, ORB oRB, Logger logger) {
        this.orb = oRB;
        this.logger = logger;
        this.decode(iOR);
    }

    public boolean equals(java.lang.Object object) {
        return object instanceof ParsedIOR && ((ParsedIOR)object).ior_str.equals(this.ior_str);
    }

    public void decode(IOR iOR) {
        block3: for (int i = 0; i < iOR.profiles.length; ++i) {
            int n = iOR.profiles[i].tag;
            switch (n) {
                case 1: {
                    this.components = new TaggedComponentList(iOR.profiles[i].profile_data);
                    continue block3;
                }
                default: {
                    Factories factories = this.orb.getTransportManager().getFactories(n);
                    if (factories != null) {
                        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder(iOR.profiles[i]);
                        this.profiles.add(factories.demarshal_profile(taggedProfileHolder, new TaggedComponentSeqHolder()));
                        continue block3;
                    }
                    if (!this.logger.isDebugEnabled()) continue block3;
                    this.logger.debug("No transport available for profile tag " + n);
                }
            }
        }
        this.effectiveProfile = this.orb.getTransportManager().getProfileSelector().selectProfile(this.profiles, this.orb.getClientConnectionManager());
        this.ior = iOR;
        this.ior_str = this.getIORString();
        if (this.effectiveProfile != null) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, class$org$omg$CONV_FRAME$CodeSetComponentInfoHelper == null ? (class$org$omg$CONV_FRAME$CodeSetComponentInfoHelper = ParsedIOR.class$("org.omg.CONV_FRAME.CodeSetComponentInfoHelper")) : class$org$omg$CONV_FRAME$CodeSetComponentInfoHelper);
            this.orbTypeId = this.getLongComponent(0);
        }
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public Integer getORBTypeId() {
        return this.orbTypeId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                cDROutputStream.beginEncapsulatedArray();
                IORHelper.write(cDROutputStream, this.ior);
                byte[] byArray = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(lookup[byArray[i] >> 4 & 0xF]);
                    stringBuffer.append(lookup[byArray[i] & 0xF]);
                }
                this.ior_str = stringBuffer.toString();
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(exception.getMessage());
                }
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public byte[] get_object_key() {
        return this.effectiveProfile.get_object_key();
    }

    public List getProfiles() {
        return this.profiles;
    }

    public Profile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        StringBuffer stringBuffer = new StringBuffer(this.getTypeId());
        stringBuffer.append(":");
        byte[] byArray = this.get_object_key();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(lookup[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(lookup[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public TaggedComponentList getMultipleComponents() {
        return this.components;
    }

    public boolean isNull() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    protected void parse(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (string.startsWith("IOR:")) {
            this.parse_stringified_ior(string);
        } else if (string.startsWith("corbaloc:")) {
            this.parse_corbaloc(string);
        } else if (string.startsWith("corbaname:")) {
            this.parse_corbaname(string);
        } else if (string.startsWith("resource:")) {
            this.parse_resource(string.substring(9));
        } else if (string.startsWith("jndi:")) {
            this.parse_jndi(string.substring(5));
        } else {
            String string2;
            block15: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to resolve URL/IOR from: " + string);
                }
                string2 = null;
                try {
                    string2 = ObjectUtil.readURL(string);
                }
                catch (IOException iOException) {
                    if (!this.logger.isDebugEnabled()) break block15;
                    this.logger.debug("Error reading IOR/URL: ", iOException);
                }
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Invalid or unreadable URL/IOR: " + string);
            }
            this.parse(string2);
        }
        this.ior_str = this.getIORString();
    }

    private void parse_stringified_ior(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = (string.length() - 4) / 2;
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i * 2 + 4);
            char c2 = string.charAt(i * 2 + 5);
            int n3 = c >= 'a' ? 10 + c - 97 : (n2 = c >= 'A' ? 10 + c - 65 : c - 48);
            int n4 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
            byteArrayOutputStream.write(n2 * 16 + n4);
        }
        CDRInputStream cDRInputStream = null;
        cDRInputStream = this.orb == null ? new CDRInputStream(org.omg.CORBA.ORB.init(), byteArrayOutputStream.toByteArray()) : new CDRInputStream(this.orb, byteArrayOutputStream.toByteArray());
        this.endianness = cDRInputStream.read_boolean();
        if (this.endianness) {
            cDRInputStream.setLittleEndian(true);
        }
        IOR iOR = IORHelper.read(cDRInputStream);
        this.decode(iOR);
    }

    private void parse_corbaloc(String string) {
        CorbaLoc corbaLoc = new CorbaLoc(this.orb, string);
        IOR iOR = null;
        if (corbaLoc.rir()) {
            try {
                Object object = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                if (object == null) {
                    throw new IllegalArgumentException("Unable to resolve reference for " + corbaLoc.getKeyString());
                }
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(exception.getMessage());
                }
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else {
            Profile profile = corbaLoc.profileList[0];
            if (profile == null) {
                return;
            }
            profile.set_object_key(this.orb.mapObjectKey(corbaLoc.getKey()));
            iOR = ParsedIOR.createObjectIOR(profile);
        }
        this.decode(iOR);
    }

    private void parse_corbaname(String string) {
        String string2 = "corbaloc:";
        String string3 = "";
        int n = string.indexOf(58);
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            string2 = string2 + string.substring(n + 1);
        } else {
            string2 = string2 + string.substring(n + 1, n2);
            string3 = string.substring(n2 + 1);
        }
        if (string2.indexOf(47) == -1) {
            string2 = string2 + "/NameService";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(string2);
        }
        try {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.orb.string_to_object(string2));
            IOR iOR = null;
            if (string3.length() > 0) {
                Object object = namingContextExt.resolve_str(string3);
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            } else {
                iOR = ((Delegate)((ObjectImpl)((java.lang.Object)namingContextExt))._get_delegate()).getIOR();
            }
            this.decode(iOR);
        }
        catch (Exception exception) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(exception.getMessage());
            }
            throw new IllegalArgumentException("Invalid object reference: " + string);
        }
    }

    private void parse_resource(String string) {
        URL uRL;
        ClassLoader classLoader;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve URL/IOR from resource: " + string);
        }
        if ((classLoader = this.getClass().getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = classLoader.getResource(string)) == null) {
            throw new IllegalArgumentException("Failed to get resource: " + string);
        }
        String string2 = null;
        try {
            ObjectUtil.readURL(uRL.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Failed to read resource: " + string);
        }
        this.parse(string2);
    }

    private void parse_jndi(String string) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve JNDI/IOR from name: " + string);
        }
        java.lang.Object object = null;
        try {
            Class[] classArray = new Class[1];
            java.lang.Object[] objectArray = new java.lang.Object[1];
            Class clazz = ObjectUtil.classForName("javax.naming.InitialContext");
            java.lang.Object t = clazz.newInstance();
            classArray[0] = class$java$lang$String == null ? (class$java$lang$String = ParsedIOR.class$("java.lang.String")) : class$java$lang$String;
            objectArray[0] = string;
            Method method = clazz.getMethod("lookup", classArray);
            object = method.invoke(t, objectArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + exception);
        }
        if (object == null) {
            throw new IllegalArgumentException("Null JNDI/IOR: " + string);
        }
        this.parse(object.toString());
    }

    private java.lang.Object getComponent(int n, Class clazz) {
        java.lang.Object object = null;
        if (this.effectiveProfile instanceof IIOPProfile) {
            object = ((IIOPProfile)this.effectiveProfile).getComponent(n, clazz);
        }
        if (object != null) {
            return object;
        }
        return this.components.getComponent(n, clazz);
    }

    private Integer getLongComponent(int n) {
        return (Integer)this.getComponent(n, class$org$jacorb$orb$ParsedIOR$LongHelper == null ? (class$org$jacorb$orb$ParsedIOR$LongHelper = ParsedIOR.class$("org.jacorb.orb.ParsedIOR$LongHelper")) : class$org$jacorb$orb$ParsedIOR$LongHelper);
    }

    private String getStringComponent(int n) {
        return (String)this.getComponent(n, class$org$jacorb$orb$ParsedIOR$StringHelper == null ? (class$org$jacorb$orb$ParsedIOR$StringHelper = ParsedIOR.class$("org.jacorb.orb.ParsedIOR$StringHelper")) : class$org$jacorb$orb$ParsedIOR$StringHelper);
    }

    public static boolean isParsableProtocol(String string) {
        return string.startsWith("IOR:") || string.startsWith("corbaloc:") || string.startsWith("corbaname:") || string.startsWith("resource:") || string.startsWith("jndi:") || string.startsWith("file:") || string.startsWith("http:");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StringHelper {
        private StringHelper() {
        }

        public static String read(InputStream inputStream) {
            return new String(inputStream.read_string());
        }
    }

    private static class LongHelper {
        private LongHelper() {
        }

        public static Integer read(InputStream inputStream) {
            return new Integer(inputStream.read_long());
        }
    }
}

