/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskProcessorRetryStrategy;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetListener;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublish;
import org.omg.CosNotifyComm.NotifyPublishHelper;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

public abstract class AbstractProxySupplier
extends AbstractProxy
implements MessageConsumer,
NotifySubscribeOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    protected Runnable scheduleDeliverPendingMessagesOperation_;
    private TaskExecutor taskExecutor_;
    private Disposable disposeTaskExecutor_;
    private EventQueue pendingMessages_;
    private int errorThreshold_;
    private java.lang.Object pendingMessagesRefLock_ = new java.lang.Object();
    private NotifyPublishOperations proxyOfferListener_;
    private NotifyPublish offerListener_;
    private boolean enabled_ = true;
    private PropertySetListener eventQueueConfigurationChangedCB = new PropertySetListener(){

        public void validateProperty(Property[] propertyArray, List list) {
        }

        public void actionPropertySetChanged(PropertySet propertySet) throws UnsupportedQoS {
            AbstractProxySupplier.this.configureEventQueue();
        }
    };

    protected AbstractProxySupplier(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        if (this.isPushSupplier()) {
            this.scheduleDeliverPendingMessagesOperation_ = new Runnable(){

                public void run() {
                    try {
                        AbstractProxySupplier.this.getTaskProcessor().scheduleTimedPushTask(AbstractProxySupplier.this);
                    }
                    catch (InterruptedException interruptedException) {
                        AbstractProxySupplier.this.logger_.fatalError("scheduleTimedPushTask failed", interruptedException);
                    }
                }
            };
        }
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.errorThreshold_ = configuration.getAttributeAsInteger("jacorb.notification.consumer.error_threshold", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preActivate() throws UnsupportedQoS {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_ = this.channelContext_.getEventQueueFactory().newEventQueue(this.qosSettings_);
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set Error Threshold to : " + this.errorThreshold_);
        }
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, this.eventQueueConfigurationChangedCB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEventQueue() throws UnsupportedQoS {
        EventQueue eventQueue = this.channelContext_.getEventQueueFactory().newEventQueue(this.qosSettings_);
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (!this.pendingMessages_.isEmpty()) {
                    Message[] messageArray = this.pendingMessages_.getAllEvents(true);
                    for (int i = 0; i < messageArray.length; ++i) {
                        eventQueue.put(messageArray[i]);
                    }
                }
                this.pendingMessages_ = eventQueue;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException.getMessage());
        }
    }

    public TaskExecutor getExecutor() {
        return this.taskExecutor_;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        if (this.taskExecutor_ != null) {
            throw new IllegalArgumentException("TaskExecutor should be set only once!");
        }
        this.taskExecutor_ = taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor, Disposable disposable) {
        this.setTaskExecutor(taskExecutor);
        this.disposeTaskExecutor_ = disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingMessagesCount() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingData() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return !this.pendingMessages_.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Message message) {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_.put(message);
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("added " + message + " to pending Messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageBlocking() throws InterruptedException {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getEvent(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageNoBlock() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getEvent(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAllMessages() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getAllEvents(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getUpToMessages(int n) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                return this.pendingMessages_.getEvents(n, false);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAtLeastMessages(int n) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (this.pendingMessages_.getSize() >= n) {
                    return this.pendingMessages_.getAllEvents(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public int getErrorThreshold() {
        return this.errorThreshold_;
    }

    public final void dispose() {
        super.dispose();
        if (this.disposeTaskExecutor_ != null) {
            this.disposeTaskExecutor_.dispose();
        }
    }

    public final ConsumerAdmin MyAdmin() {
        return ConsumerAdminHelper.narrow(this.admin_.activate());
    }

    public final void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(eventTypeArray, eventTypeArray2);
    }

    public final EventType[] obtain_offered_types(ObtainInfoMode obtainInfoMode) {
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.offerManager_.obtain_offered_types();
                break;
            }
            case 0: {
                eventTypeArray = this.offerManager_.obtain_offered_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode");
            }
        }
        return eventTypeArray;
    }

    private void registerListener() {
        NotifyPublishOperations notifyPublishOperations;
        if (this.proxyOfferListener_ == null && (notifyPublishOperations = this.getOfferListener()) != null) {
            this.proxyOfferListener_ = new NotifyPublishOperations(){

                public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        notifyPublishOperations.offer_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        AbstractProxySupplier.this.logger_.info("disable offer_change for connected Consumer.", nO_IMPLEMENT);
                        AbstractProxySupplier.this.removeListener();
                    }
                    catch (InvalidEventType invalidEventType) {
                        AbstractProxySupplier.this.logger_.error("invalid event type", invalidEventType);
                    }
                }
            };
            this.offerManager_.addListener(this.proxyOfferListener_);
        }
    }

    private void removeListener() {
        if (this.proxyOfferListener_ != null) {
            this.offerManager_.removeListener(this.proxyOfferListener_);
            this.proxyOfferListener_ = null;
        }
    }

    final NotifyPublishOperations getOfferListener() {
        return this.offerListener_;
    }

    protected void connectClient(Object object) {
        super.connectClient(object);
        try {
            this.offerListener_ = NotifyPublishHelper.narrow(object);
            this.logger_.debug("successfully narrowed connecting Client to IF NotifyPublish");
        }
        catch (Throwable throwable) {
            this.logger_.info("disable offer_change for connecting Consumer");
        }
    }

    public synchronized void enableDelivery() {
        this.enabled_ = true;
    }

    public synchronized void disableDelivery() {
        this.enabled_ = false;
    }

    protected synchronized boolean isEnabled() {
        return this.enabled_;
    }

    static AbstractProxySupplier newProxyPullSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        abstractProxySupplier.configure(((ORB)abstractAdmin.getORB()).getConfiguration());
        return abstractProxySupplier;
    }

    static AbstractProxySupplier newProxyPushSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        abstractProxySupplier.configure(((ORB)abstractAdmin.getORB()).getConfiguration());
        return abstractProxySupplier;
    }

    public boolean isPushSupplier() {
        switch (this.MyType().value()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected void handleFailedPushOperation(PushOperation pushOperation, Throwable throwable) {
        if (RetryStrategy.isFatalException(throwable)) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("push raised " + throwable + ": will destroy ProxySupplier, " + "disconnect Consumer", throwable);
            }
            pushOperation.dispose();
            this.dispose();
            return;
        }
        RetryStrategy retryStrategy = this.getRetryStrategy(this, pushOperation);
        try {
            retryStrategy.retry();
        }
        catch (RetryException retryException) {
            this.logger_.error("retry failed", retryException);
        }
    }

    private RetryStrategy getRetryStrategy(MessageConsumer messageConsumer, PushOperation pushOperation) {
        return new TaskProcessorRetryStrategy(messageConsumer, pushOperation, this.getTaskProcessor());
    }
}

