/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.FilterImpl;
import org.jacorb.notification.MappingFilterImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable,
Configurable {
    public static final String CONSTRAINT_GRAMMAR = "EXTENDED_TCL";
    private ApplicationContext applicationContext_;
    private ORB orb_;
    private POA poa_;
    private boolean isApplicationContextCreatedHere_;
    private List allFilters_ = new ArrayList();
    private Object allFiltersLock_ = this.allFilters_;
    private FilterFactory thisRef_;
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    public FilterFactoryImpl() throws InvalidName, AdapterInactive {
        this.orb_ = ORB.init(new String[0], null);
        this.poa_ = POAHelper.narrow(this.orb_.resolve_initial_references("RootPOA"));
        this.applicationContext_ = new ApplicationContext(this.orb_, this.poa_);
        this.applicationContext_.configure(((org.jacorb.orb.ORB)this.orb_).getConfiguration());
        this.isApplicationContextCreatedHere_ = true;
        this.getFilterFactory();
        this.poa_.the_POAManager().activate();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FilterFactoryImpl.this.orb_.run();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public FilterFactoryImpl(ApplicationContext applicationContext) throws InvalidName {
        this.applicationContext_ = applicationContext;
        this.poa_ = applicationContext.getPoa();
        this.orb_ = applicationContext.getOrb();
        this.isApplicationContextCreatedHere_ = false;
    }

    public void configure(Configuration configuration) {
        this.config_ = (org.jacorb.config.Configuration)configuration;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter create_filter(String string) throws InvalidGrammar {
        final FilterImpl filterImpl = this.create_filter_servant(string);
        filterImpl.setORB(this.orb_);
        filterImpl.setPOA(this.poa_);
        filterImpl.preActivate();
        Filter filter = FilterHelper.narrow(filterImpl.activate());
        Object object = this.allFiltersLock_;
        synchronized (object) {
            this.allFilters_.add(filterImpl);
            filterImpl.setDisposeHook(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = FilterFactoryImpl.this.allFiltersLock_;
                    synchronized (object) {
                        FilterFactoryImpl.this.allFilters_.remove(filterImpl);
                    }
                }
            });
        }
        return filter;
    }

    private FilterImpl create_filter_servant(String string) throws InvalidGrammar {
        if (CONSTRAINT_GRAMMAR.equals(string)) {
            FilterImpl filterImpl = new FilterImpl(this.applicationContext_, CONSTRAINT_GRAMMAR);
            filterImpl.configure(this.config_);
            return filterImpl;
        }
        throw new InvalidGrammar("Constraint Language '" + string + "' is not supported. Try one of the following: " + CONSTRAINT_GRAMMAR);
    }

    public MappingFilter create_mapping_filter(String string, Any any) throws InvalidGrammar {
        FilterImpl filterImpl = this.create_filter_servant(string);
        MappingFilterImpl mappingFilterImpl = new MappingFilterImpl(this.applicationContext_, filterImpl, any);
        mappingFilterImpl.configure(this.config_);
        MappingFilter mappingFilter = mappingFilterImpl._this(this.orb_);
        return mappingFilter;
    }

    public void dispose() {
        Iterator iterator = this.getAllFilters().iterator();
        while (iterator.hasNext()) {
            Disposable disposable = (Disposable)iterator.next();
            iterator.remove();
            disposable.dispose();
        }
        if (this.isApplicationContextCreatedHere_) {
            this.orb_.shutdown(true);
            this.applicationContext_.dispose();
        }
    }

    public synchronized FilterFactory getFilterFactory() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
        }
        return this.thisRef_;
    }

    public POA _default_POA() {
        return this.poa_;
    }

    public List getAllFilters() {
        return this.allFilters_;
    }
}

