/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import org.jacorb.imr.util.ImRModel;

public class AddServerWindow
extends JFrame
implements ActionListener,
KeyListener {
    private ImRModel m_model;
    private JTextField m_name_tf;
    private JComboBox m_host_box;
    private JTextField m_command_tf;
    private Component host_box_tf = null;
    private JButton m_add_btn;
    private JButton m_cancel_btn;
    private Clipboard clip_board = null;

    public AddServerWindow(ImRModel imRModel) {
        super("Add Server");
        this.m_model = imRModel;
        this.clip_board = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.addKeyListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel("Servername: ");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.m_name_tf = new JTextField();
        this.m_name_tf.requestFocus();
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100, 1);
        gridBagLayout.setConstraints(this.m_name_tf, gridBagConstraints);
        jPanel.add(this.m_name_tf);
        JLabel jLabel2 = new JLabel("Host: ");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 1, 1);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.m_host_box = this.m_model.getHostSelector();
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100, 1);
        gridBagLayout.setConstraints(this.m_host_box, gridBagConstraints);
        jPanel.add(this.m_host_box);
        this.host_box_tf = this.m_host_box.getEditor().getEditorComponent();
        JLabel jLabel3 = new JLabel("Command: ");
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 1, 1);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this.m_command_tf = new JTextField(30);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100, 1);
        gridBagLayout.setConstraints(this.m_command_tf, gridBagConstraints);
        jPanel.add(this.m_command_tf);
        this.m_add_btn = new JButton("Add");
        this.m_add_btn.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.m_add_btn, gridBagConstraints);
        jPanel.add(this.m_add_btn);
        this.m_cancel_btn = new JButton("Cancel");
        this.m_cancel_btn.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 1, 1);
        gridBagLayout.setConstraints(this.m_cancel_btn, gridBagConstraints);
        jPanel.add(this.m_cancel_btn);
        jPanel.setLayout(gridBagLayout);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setVisible(true);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.m_cancel_btn) {
            this.dispose();
        } else if (jButton == this.m_add_btn) {
            this.dispose();
            this.m_model.addServer(this.m_name_tf.getText(), this.m_command_tf.getText(), (String)this.m_host_box.getSelectedItem());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyCode() == 65487) {
                Transferable transferable = this.clip_board.getContents(this);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (this.m_name_tf.hasFocus()) {
                    this.m_name_tf.setText(string);
                } else if (this.m_command_tf.hasFocus()) {
                    this.m_command_tf.setText(string);
                } else if (this.host_box_tf.hasFocus()) {
                    MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.m_host_box.getModel();
                    mutableComboBoxModel.addElement(string);
                    mutableComboBoxModel.setSelectedItem(string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

