/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.properties;

import com.isencia.properties.IPropertyContainer;
import com.isencia.properties.PropertiesLoadingException;
import com.isencia.properties.XmlHierarchicProperty;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlPropertyContainer
extends XmlHierarchicProperty
implements IPropertyContainer {
    private static final String rootTag = "PropertiesBag";
    private Document properties = null;
    private String name = null;
    private String sourceName = null;

    protected XmlPropertyContainer() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void loadProperties(Reader reader) throws PropertiesLoadingException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            this.properties = sAXBuilder.build(reader);
            this.parseProperties();
        }
        catch (JDOMException jDOMException) {
            throw new PropertiesLoadingException("Properties input read failed", jDOMException);
        }
        catch (IOException iOException) {
            throw new PropertiesLoadingException("Properties input read failed", iOException);
        }
    }

    private void parseProperties() throws PropertiesLoadingException {
        this.rootElement = this.properties.getRootElement();
        if (this.rootElement == null || !this.rootElement.getName().equals(rootTag)) {
            throw new PropertiesLoadingException("Root element name PropertiesBag not found in properties file.");
        }
        this.name = this.rootElement.getAttributeValue("name");
    }

    @Override
    public void setSourceName(String string) {
        this.sourceName = string;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(this.properties, (Writer)stringWriter);
        }
        catch (Exception exception) {}
        return ((Object)stringWriter).toString();
    }
}

