/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CommentEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CompositeActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DirectorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteBuilder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.AtomicActor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Changeable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.ValueListener;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class OutlineEditPart
extends AbstractTreeEditPart
implements ValueListener,
ChangeListener {
    private static HashMap<String, Image> modelImages = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(OutlineEditPart.class);

    public OutlineEditPart(Object object) {
        super(object);
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            parameter.addValueListener((ValueListener)this);
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        if (this.getNamedObjectModel() instanceof Changeable) {
            NamedObj namedObj = this.getNamedObjectModel();
            namedObj.addChangeListener((ChangeListener)this);
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        if (this.getNamedObjectModel() instanceof Changeable) {
            NamedObj namedObj = this.getNamedObjectModel();
            namedObj.removeChangeListener((ChangeListener)this);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
    }

    protected NamedObj getNamedObjectModel() {
        return (NamedObj)this.getModel();
    }

    protected List getModelChildren() {
        NamedObj namedObj = this.getNamedObjectModel();
        ArrayList arrayList = new ArrayList();
        if (namedObj instanceof AtomicActor) {
            AtomicActor atomicActor = (AtomicActor)namedObj;
            arrayList.addAll(atomicActor.attributeList(Parameter.class));
            arrayList.addAll(atomicActor.inputPortList());
            arrayList.addAll(atomicActor.outputPortList());
        } else if (namedObj instanceof CompositeActor) {
            CompositeActor compositeActor = (CompositeActor)namedObj;
            arrayList.addAll(compositeActor.attributeList(AtomicActor.class));
            arrayList.addAll(compositeActor.attributeList(Parameter.class));
            arrayList.addAll(compositeActor.inputPortList());
            Enumeration enumeration = compositeActor.getEntities();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        } else if (namedObj instanceof IOPort) {
            IOPort iOPort = (IOPort)namedObj;
            arrayList.addAll(iOPort.attributeList(StringAttribute.class));
        } else if (namedObj instanceof Vertex) {
            Vertex vertex = (Vertex)namedObj;
            arrayList.addAll(vertex.attributeList(Vertex.class));
        } else if (namedObj instanceof TextAttribute) {
            TextAttribute textAttribute = (TextAttribute)namedObj;
            arrayList.addAll(textAttribute.attributeList(StringAttribute.class));
        } else if (namedObj instanceof Director) {
            Director director = (Director)namedObj;
            arrayList.addAll(director.attributeList(Parameter.class));
        }
        return arrayList;
    }

    protected void refreshVisuals() {
        IOPort iOPort;
        if (this.getWidget() instanceof Tree) {
            return;
        }
        NamedObj namedObj = this.getNamedObjectModel();
        if (namedObj instanceof Director) {
            this.setWidgetImage(DirectorEditPart.IMAGE_DESCRIPTOR_DIRECTOR, namedObj);
        } else if (namedObj instanceof Parameter) {
            this.setWidgetImage(ActorEditPart.IMAGE_DESCRIPTOR_PARAMETER, namedObj);
        } else if (namedObj instanceof IOPort) {
            iOPort = (IOPort)namedObj;
            if (iOPort.isInput()) {
                this.setWidgetImage(ActorEditPart.IMAGE_DESCRIPTOR_INPUTPORT, namedObj);
            } else {
                this.setWidgetImage(ActorEditPart.IMAGE_DESCRIPTOR_OUTPUTPORT, namedObj);
            }
        } else if (namedObj instanceof TypedAtomicActor) {
            this.setWidgetImage(ActorEditPart.IMAGE_DESCRIPTOR_ACTOR, namedObj);
        } else if (namedObj instanceof CompositeActor) {
            this.setWidgetImage(CompositeActorEditPart.IMAGE_DESCRIPTOR_COMPOSITEACTOR, namedObj);
        } else if (namedObj instanceof Vertex) {
            this.setWidgetImage(CommentEditPart.IMAGE_COMMENT, namedObj);
        } else if (namedObj instanceof TextAttribute) {
            this.setWidgetImage(CommentEditPart.IMAGE_COMMENT, namedObj);
        } else if (namedObj instanceof TypedIOPort) {
            if (((IOPort)namedObj).isInput()) {
                this.setWidgetImage(PaletteBuilder.getIcon("com.isencia.passerelle.actor.general.InputIOPort"), namedObj);
            } else {
                this.setWidgetImage(PaletteBuilder.getIcon("com.isencia.passerelle.actor.general.OutputIOPort"), namedObj);
            }
        }
        if (namedObj instanceof Parameter) {
            iOPort = (Parameter)namedObj;
            String string = iOPort.getName();
            String string2 = iOPort.getExpression();
            this.setWidgetText(String.valueOf(string) + "=" + (string2 == null ? "" : string2));
        } else {
            this.setWidgetText(namedObj.getName());
        }
    }

    public void valueChanged(Settable settable) {
        this.refreshVisuals();
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        try {
            this.refreshVisuals();
            this.refreshChildren();
        }
        catch (Exception exception) {}
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        this.getLogger().error("Error during execution of ChangeRequest", (Throwable)exception);
    }

    protected void setWidgetImage(ImageDescriptor imageDescriptor, NamedObj namedObj) {
        if (modelImages.get(namedObj.getClass().getName()) == null) {
            Image image = imageDescriptor.createImage();
            this.setWidgetImage(image);
            modelImages.put(namedObj.getClass().getName(), image);
        } else {
            this.setWidgetImage(modelImages.get(namedObj.getClass().getName()));
        }
    }
}

