/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.INameable;
import com.isencia.passerelle.workbench.model.editor.ui.properties.ActorGeneralSection;
import com.isencia.passerelle.workbench.model.editor.ui.properties.CommentPropertySource;
import com.isencia.passerelle.workbench.model.editor.ui.properties.EntityPropertySource;
import com.isencia.passerelle.workbench.model.ui.command.ChangeActorPropertyCommand;
import com.isencia.passerelle.workbench.model.ui.command.CreateConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteComponentCommand;
import com.isencia.passerelle.workbench.model.ui.command.SetConstraintCommand;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Changeable;
import ptolemy.kernel.util.NamedObj;

public abstract class AbstractBaseEditPart
extends AbstractGraphicalEditPart
implements ChangeListener {
    protected Set<Image> images = new HashSet<Image>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseEditPart.class);
    private AccessibleEditPart acc;
    protected IPropertySource propertySource = null;

    public Set<Image> getImages() {
        return this.images;
    }

    protected Image createImage(ImageDescriptor imageDescriptor) {
        Image image = imageDescriptor.createImage();
        this.images.add(image);
        return image;
    }

    public AbstractBaseEditPart() {
        this.addNodeListener(new NodeListener(){

            public void removingSourceConnection(ConnectionEditPart connectionEditPart, int n) {
            }

            public void removingTargetConnection(ConnectionEditPart connectionEditPart, int n) {
            }

            public void sourceConnectionAdded(ConnectionEditPart connectionEditPart, int n) {
            }

            public void targetConnectionAdded(ConnectionEditPart connectionEditPart, int n) {
            }
        });
        this.addEditPartListener(new EditPartListener(){

            public void selectedStateChanged(EditPart editPart) {
            }

            public void removingChild(EditPart editPart, int n) {
            }

            public void partDeactivated(EditPart editPart) {
            }

            public void partActivated(EditPart editPart) {
            }

            public void childAdded(EditPart editPart, int n) {
            }
        });
    }

    protected abstract AccessibleEditPart createAccessible();

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        if (this.getEntity() instanceof Changeable) {
            NamedObj namedObj = this.getEntity();
            namedObj.addChangeListener((ChangeListener)this);
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        if (this.getEntity() instanceof Changeable) {
            NamedObj namedObj = this.getEntity();
            namedObj.removeChangeListener((ChangeListener)this);
        }
        super.deactivate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    public NamedObj getEntity() {
        return (NamedObj)this.getModel();
    }

    protected Figure getComponentFigure() {
        return (Figure)this.getFigure();
    }

    public void refreshVisuals() {
        double[] dArray = ModelUtils.getLocation((NamedObj)this.getEntity());
        Rectangle rectangle = new Rectangle(new Point(dArray[0], dArray[1]), this.getComponentFigure().getPreferredSize(-1, -1));
        if (this.getParent() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
        }
    }

    public Object getAdapter(Class clazz) {
        if (IPropertySource.class == clazz) {
            return this.getPropertySource();
        }
        return super.getAdapter(clazz);
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new EntityPropertySource(this.getEntity(), this.getFigure());
        }
        return this.propertySource;
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        this.getLogger().debug("Change Executed");
        Object object = changeRequest.getSource();
        if (changeRequest instanceof ModelChangeRequest) {
            Class clazz = ((ModelChangeRequest)changeRequest).getType();
            if (ActorGeneralSection.class.equals((Object)clazz) || CommentPropertySource.class.equals((Object)clazz)) {
                if (object == this.getModel() && object instanceof NamedObj) {
                    String string = this.getName(object);
                    if (this.getComponentFigure() instanceof INameable && string != null && !string.equals(((INameable)this.getComponentFigure()).getName())) {
                        this.getViewer().getEditDomain().getCommandStack().execute((Command)new ChangeActorPropertyCommand());
                        ((INameable)this.getComponentFigure()).setName(string);
                        this.getFigure().repaint();
                    }
                    this.specificTreatment(object);
                }
            } else if (SetConstraintCommand.class.equals((Object)clazz) && object == this.getModel() && object instanceof NamedObj) {
                this.refresh();
            }
            if (EntityPropertySource.class.equals((Object)clazz) || CommentPropertySource.class.equals((Object)clazz)) {
                if (object == this.getModel()) {
                    this.getViewer().getEditDomain().getCommandStack().execute((Command)new ChangeActorPropertyCommand());
                }
            } else if (DeleteComponentCommand.class.equals((Object)clazz) || CreateConnectionCommand.class.equals((Object)clazz)) {
                try {
                    this.refreshSourceConnections();
                    this.refreshTargetConnections();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void specificTreatment(Object object) {
    }

    protected String getName(Object object) {
        String string = ((NamedObj)object).getDisplayName();
        return string;
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        this.getLogger().debug("Change Failed : " + exception.getMessage());
    }

    public Logger getLogger() {
        return logger;
    }
}

