/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui;

import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractBaseEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.RelationEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexRelationEditPart;
import com.isencia.passerelle.workbench.model.ui.command.CopyNodeCommand;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyNodeAction
extends SelectionAction {
    private CopyNodeCommand CopyNodeCommand;

    public CopyNodeAction(IWorkbenchPart iWorkbenchPart) {
        super(iWorkbenchPart);
        this.setLazyEnablementCalculation(true);
    }

    private CopyNodeCommand getCopyNodeCommand() {
        if (this.CopyNodeCommand == null) {
            this.CopyNodeCommand = new CopyNodeCommand();
            return this.CopyNodeCommand;
        }
        return this.CopyNodeCommand;
    }

    protected void init() {
        super.init();
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText("Copy");
        this.setId(ActionFactory.COPY.getId());
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    private Command createCopyCommand(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        CopyNodeCommand copyNodeCommand = this.getCopyNodeCommand();
        copyNodeCommand.emptyElementList();
        for (Object object : list) {
            if (!(object instanceof AbstractEditPart)) {
                return null;
            }
            if (!(object instanceof AbstractBaseEditPart) && !(object instanceof RelationEditPart) && !(object instanceof VertexRelationEditPart)) continue;
            AbstractEditPart abstractEditPart = (AbstractEditPart)object;
            Object object2 = abstractEditPart.getModel();
            if (!copyNodeCommand.isCopyableNamedObj(object2)) {
                return null;
            }
            copyNodeCommand.addElement(object2);
        }
        return copyNodeCommand;
    }

    protected boolean calculateEnabled() {
        boolean bl = this.checkSelectedObjects();
        return bl;
    }

    private boolean checkSelectedObjects() {
        if (this.getSelectedObjects() == null) {
            return false;
        }
        for (Object e : this.getSelectedObjects()) {
            if (!(e instanceof EditPart) || e instanceof DiagramEditPart) continue;
            return true;
        }
        return false;
    }

    public void run() {
        Command command = this.createCopyCommand(this.getSelectedObjects());
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }

    protected void setSelection(ISelection iSelection) {
        super.setSelection(iSelection);
    }
}

