/*
 * Decompiled with CFR 0.152.
 */
package org.edna.passerelle.common.commands;

import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowManager;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class ExecuteCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        FlowManager flowManager = new FlowManager();
        IFile iFile = this.getWorkflowSelected();
        if (iFile == null) {
            throw new ExecutionException("NO FILE SELECTED - INFORM USER!");
        }
        try {
            URL uRL = iFile.getLocation().toFile().toURL();
            Flow flow = FlowManager.readMoml((URL)uRL);
            flowManager.executeBlocking(flow, new HashMap(3));
            return Boolean.TRUE;
        }
        catch (Exception exception) {
            throw new ExecutionException("Cannot execute " + iFile.getName(), (Throwable)exception);
        }
    }

    private IFile getWorkflowSelected() {
        IFile iFile;
        IEditorPart iEditorPart = EclipseUtils.getActivePage().getActiveEditor();
        if (iEditorPart != null && (iFile = EclipseUtils.getIFile((IEditorInput)iEditorPart.getEditorInput())).getName().endsWith(".moml")) {
            return iFile;
        }
        iFile = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (iFile != null) {
            IFile iFile2;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iFile.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
            if (iStructuredSelection == null) {
                iStructuredSelection = (IStructuredSelection)iFile.getSelection("org.eclipse.jdt.ui.PackageExplorer");
            }
            if ((iFile2 = (IFile)iStructuredSelection.getFirstElement()).getName().endsWith(".moml")) {
                return iFile2;
            }
        }
        return null;
    }
}

