/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

final class JavaLexBitSet
implements Cloneable {
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public JavaLexBitSet() {
        this(64);
    }

    public JavaLexBitSet(int nbits) {
        this.bits = new long[this.nbits2size(nbits)];
    }

    private int nbits2size(int nbits) {
        return (nbits >> 6) + 1;
    }

    private void resize(int nbits) {
        int newsize = Math.max(this.bits.length, this.nbits2size(nbits));
        long[] newbits = new long[newsize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void set(int bit) {
        int n = bit >> 6;
        if (n >= this.bits.length) {
            this.resize(bit);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | 1L << (bit & 0x3F);
    }

    public void clear(int bit) {
        int n = bit >> 6;
        if (n >= this.bits.length) {
            this.resize(bit);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean get(int bit) {
        int n = bit >> 6;
        return n < this.bits.length ? (this.bits[n] & 1L << (bit & 0x3F)) != 0L : false;
    }

    public void and(JavaLexBitSet set) {
        int n;
        int i = n = Math.min(this.bits.length, set.bits.length);
        while (i-- > 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
        }
        while (n < this.bits.length) {
            this.bits[n] = 0L;
            ++n;
        }
    }

    public void or(JavaLexBitSet set) {
        int i = Math.min(this.bits.length, set.bits.length);
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
        }
    }

    public void xor(JavaLexBitSet set) {
        int i = Math.min(this.bits.length, set.bits.length);
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
        }
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (long)i;
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JavaLexBitSet) {
            int n;
            JavaLexBitSet set = (JavaLexBitSet)obj;
            int i = n = Math.min(this.bits.length, set.bits.length);
            while (i-- > 0) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            if (this.bits.length > n) {
                i = this.bits.length;
                while (i-- > n) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
            } else if (set.bits.length > n) {
                i = set.bits.length;
                while (i-- > n) {
                    if (set.bits[i] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            JavaLexBitSet set = (JavaLexBitSet)super.clone();
            set.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, set.bits, 0, this.bits.length);
            return set;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.get(i)) {
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(i);
            }
            ++i;
        }
        return "{" + str.toString() + "}";
    }
}

