/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

import com.JLex.CAlloc;
import com.JLex.CBunch;
import com.JLex.CDTrans;
import com.JLex.CDfa;
import com.JLex.CLexGen;
import com.JLex.CNfa;
import com.JLex.CSpec;
import com.JLex.CUtility;
import com.JLex.JavaLexBitSet;
import java.util.Stack;
import java.util.Vector;

class CNfa2Dfa {
    private CSpec m_spec;
    private int m_unmarked_dfa;
    private CLexGen m_lexGen;
    private static final int NOT_IN_DSTATES = -1;

    CNfa2Dfa() {
        this.reset();
    }

    private void set(CLexGen lexGen, CSpec spec) {
        this.m_spec = spec;
        this.m_unmarked_dfa = 0;
    }

    private void reset() {
        this.m_spec = null;
        this.m_unmarked_dfa = 0;
    }

    void make_dfa(CLexGen lexGen, CSpec spec) {
        this.reset();
        this.set(lexGen, spec);
        this.make_dtrans();
        this.free_nfa_states();
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        this.free_dfa_states();
    }

    private void make_dtrans() {
        System.out.print("Working on DFA states.");
        CBunch bunch = new CBunch();
        this.m_unmarked_dfa = 0;
        int nstates = this.m_spec.m_state_rules.length;
        this.m_spec.m_state_dtrans = new int[nstates];
        int istate = 0;
        while (nstates > istate) {
            if (this.m_spec.m_state_rules[istate].size() == 0) {
                this.m_spec.m_state_dtrans[istate] = -1;
            } else {
                CDfa dfa;
                bunch.m_nfa_set = (Vector)this.m_spec.m_state_rules[istate].clone();
                this.sortStates(bunch.m_nfa_set);
                bunch.m_nfa_bit = new JavaLexBitSet();
                int size = bunch.m_nfa_set.size();
                int i = 0;
                while (size > i) {
                    CNfa nfa = (CNfa)bunch.m_nfa_set.elementAt(i);
                    bunch.m_nfa_bit.set(nfa.m_label);
                    ++i;
                }
                bunch.m_accept = null;
                bunch.m_anchor = 0;
                bunch.m_accept_index = Integer.MAX_VALUE;
                this.e_closure(bunch);
                this.add_to_dstates(bunch);
                this.m_spec.m_state_dtrans[istate] = this.m_spec.m_dtrans_vector.size();
                while ((dfa = this.get_unmarked()) != null) {
                    System.out.print(".");
                    System.out.flush();
                    CUtility.cuassert(!dfa.m_mark);
                    dfa.m_mark = true;
                    CDTrans dtrans = new CDTrans(this.m_spec.m_dtrans_vector.size(), this.m_spec);
                    dtrans.m_accept = dfa.m_accept;
                    dtrans.m_anchor = dfa.m_anchor;
                    i = 0;
                    while (i < this.m_spec.m_dtrans_ncols) {
                        int nextstate;
                        CUtility.cuassert(i >= 0);
                        CUtility.cuassert(this.m_spec.m_dtrans_ncols > i);
                        this.move(dfa.m_nfa_set, dfa.m_nfa_bit, i, bunch);
                        if (bunch.m_nfa_set != null) {
                            this.e_closure(bunch);
                        }
                        CUtility.cuassert(bunch.m_nfa_set == null && bunch.m_nfa_bit == null || bunch.m_nfa_set != null && bunch.m_nfa_bit != null);
                        if (bunch.m_nfa_set == null) {
                            nextstate = -1;
                        } else {
                            nextstate = this.in_dstates(bunch);
                            if (-1 == nextstate) {
                                nextstate = this.add_to_dstates(bunch);
                            }
                        }
                        CUtility.cuassert(nextstate < this.m_spec.m_dfa_states.size());
                        dtrans.m_dtrans[i] = nextstate;
                        ++i;
                    }
                    CUtility.cuassert(this.m_spec.m_dtrans_vector.size() == dfa.m_label);
                    this.m_spec.m_dtrans_vector.addElement(dtrans);
                }
            }
            ++istate;
        }
        System.out.println("");
    }

    private void free_dfa_states() {
        this.m_spec.m_dfa_states = null;
        this.m_spec.m_dfa_sets = null;
    }

    private void free_nfa_states() {
        this.m_spec.m_nfa_states = null;
        this.m_spec.m_nfa_start = null;
        this.m_spec.m_state_rules = null;
    }

    private void e_closure(CBunch bunch) {
        CNfa state;
        CUtility.cuassert(bunch != null);
        CUtility.cuassert(bunch.m_nfa_set != null);
        CUtility.cuassert(bunch.m_nfa_bit != null);
        bunch.m_accept = null;
        bunch.m_anchor = 0;
        bunch.m_accept_index = Integer.MAX_VALUE;
        Stack<CNfa> nfa_stack = new Stack<CNfa>();
        int size = bunch.m_nfa_set.size();
        int i = 0;
        while (i < size) {
            state = (CNfa)bunch.m_nfa_set.elementAt(i);
            CUtility.cuassert(bunch.m_nfa_bit.get(state.m_label));
            nfa_stack.push(state);
            ++i;
        }
        while (!nfa_stack.empty()) {
            state = (CNfa)nfa_stack.pop();
            if (state.m_accept != null && state.m_label < bunch.m_accept_index) {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;
                CUtility.cuassert(bunch.m_accept != null);
                CUtility.cuassert(bunch.m_anchor == 0 || (bunch.m_anchor & 2) != 0 || (bunch.m_anchor & 1) != 0);
            }
            if (-3 != state.m_edge) continue;
            if (state.m_next != null && !bunch.m_nfa_set.contains(state.m_next)) {
                CUtility.cuassert(!bunch.m_nfa_bit.get(state.m_next.m_label));
                bunch.m_nfa_bit.set(state.m_next.m_label);
                bunch.m_nfa_set.addElement(state.m_next);
                nfa_stack.push(state.m_next);
            }
            if (state.m_next2 == null || bunch.m_nfa_set.contains(state.m_next2)) continue;
            CUtility.cuassert(!bunch.m_nfa_bit.get(state.m_next2.m_label));
            bunch.m_nfa_bit.set(state.m_next2.m_label);
            bunch.m_nfa_set.addElement(state.m_next2);
            nfa_stack.push(state.m_next2);
        }
        if (bunch.m_nfa_set != null) {
            this.sortStates(bunch.m_nfa_set);
        }
    }

    void move(Vector nfa_set, JavaLexBitSet nfa_bit, int b, CBunch bunch) {
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;
        int size = nfa_set.size();
        int index = 0;
        while (index < size) {
            CNfa state = (CNfa)nfa_set.elementAt(index);
            if (b == state.m_edge || -1 == state.m_edge && state.m_set.contains(b)) {
                if (bunch.m_nfa_set == null) {
                    CUtility.cuassert(bunch.m_nfa_bit == null);
                    bunch.m_nfa_set = new Vector();
                    bunch.m_nfa_bit = new JavaLexBitSet();
                }
                bunch.m_nfa_set.addElement(state.m_next);
                bunch.m_nfa_bit.set(state.m_next.m_label);
            }
            ++index;
        }
        if (bunch.m_nfa_set != null) {
            CUtility.cuassert(bunch.m_nfa_bit != null);
            this.sortStates(bunch.m_nfa_set);
        }
    }

    private void sortStates(Vector nfa_set) {
        int size = nfa_set.size();
        int begin = 0;
        while (begin < size) {
            CNfa elem = (CNfa)nfa_set.elementAt(begin);
            int smallest_value = elem.m_label;
            int smallest_index = begin;
            int index = begin + 1;
            while (index < size) {
                elem = (CNfa)nfa_set.elementAt(index);
                int value = elem.m_label;
                if (value < smallest_value) {
                    smallest_index = index;
                    smallest_value = value;
                }
                ++index;
            }
            CNfa begin_elem = (CNfa)nfa_set.elementAt(begin);
            elem = (CNfa)nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem, begin);
            nfa_set.setElementAt(begin_elem, smallest_index);
            ++begin;
        }
    }

    private CDfa get_unmarked() {
        int size = this.m_spec.m_dfa_states.size();
        while (this.m_unmarked_dfa < size) {
            CDfa dfa = (CDfa)this.m_spec.m_dfa_states.elementAt(this.m_unmarked_dfa);
            if (!dfa.m_mark) {
                boolean cfr_ignored_0 = this.m_spec.m_verbose;
                return dfa;
            }
            ++this.m_unmarked_dfa;
        }
        return null;
    }

    private int add_to_dstates(CBunch bunch) {
        CUtility.cuassert(bunch.m_nfa_set != null);
        CUtility.cuassert(bunch.m_nfa_bit != null);
        CUtility.cuassert(bunch.m_accept != null || bunch.m_anchor == 0);
        CDfa dfa = CAlloc.newCDfa(this.m_spec);
        dfa.m_nfa_set = (Vector)bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (JavaLexBitSet)bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        this.m_spec.m_dfa_sets.put(dfa.m_nfa_bit, dfa);
        return dfa.m_label;
    }

    private int in_dstates(CBunch bunch) {
        CDfa dfa = (CDfa)this.m_spec.m_dfa_sets.get(bunch.m_nfa_bit);
        if (dfa != null) {
            return dfa.m_label;
        }
        return -1;
    }
}

