/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

import com.JLex.CAlloc;
import com.JLex.CError;
import com.JLex.CInput;
import com.JLex.CLexGen;
import com.JLex.CNfa;
import com.JLex.CNfaPair;
import com.JLex.CSet;
import com.JLex.CSpec;
import com.JLex.CUtility;
import com.JLex.JavaLexBitSet;
import java.io.IOException;
import java.util.Vector;

class CMakeNfa {
    private CSpec m_spec;
    private CLexGen m_lexGen;
    private CInput m_input;

    CMakeNfa() {
        this.reset();
    }

    private void reset() {
        this.m_input = null;
        this.m_lexGen = null;
        this.m_spec = null;
    }

    private void set(CLexGen lexGen, CSpec spec, CInput input) {
        CUtility.cuassert(input != null);
        CUtility.cuassert(lexGen != null);
        CUtility.cuassert(spec != null);
        this.m_input = input;
        this.m_lexGen = lexGen;
        this.m_spec = spec;
    }

    void thompson(CLexGen lexGen, CSpec spec, CInput input) throws IOException {
        this.reset();
        this.set(lexGen, spec, input);
        int size = this.m_spec.m_states.size();
        this.m_spec.m_state_rules = new Vector[size];
        int i = 0;
        while (i < size) {
            this.m_spec.m_state_rules[i] = new Vector();
            ++i;
        }
        this.m_spec.m_nfa_start = this.machine();
        size = this.m_spec.m_nfa_states.size();
        i = 0;
        while (i < size) {
            CNfa elem = (CNfa)this.m_spec.m_nfa_states.elementAt(i);
            elem.m_label = i++;
        }
        if (this.m_spec.m_verbose) {
            System.out.println("NFA comprised of " + (this.m_spec.m_nfa_states.size() + 1) + " states.");
        }
        this.reset();
    }

    private void discardCNfa(CNfa nfa) {
        this.m_spec.m_nfa_states.removeElement(nfa);
    }

    private void processStates(JavaLexBitSet states, CNfa current) {
        int size = this.m_spec.m_states.size();
        int i = 0;
        while (i < size) {
            if (states.get(i)) {
                this.m_spec.m_state_rules[i].addElement(current);
            }
            ++i;
        }
    }

    private CNfa machine() throws IOException {
        CNfa start;
        JavaLexBitSet states = this.m_lexGen.getStates();
        this.m_spec.m_current_token = 1;
        this.m_lexGen.advance();
        CNfa p = start = CAlloc.newCNfa(this.m_spec);
        p.m_next = this.rule();
        this.processStates(states, p.m_next);
        while (11 != this.m_spec.m_current_token) {
            states = this.m_lexGen.getStates();
            this.m_lexGen.advance();
            if (11 == this.m_spec.m_current_token) break;
            p = p.m_next2 = CAlloc.newCNfa(this.m_spec);
            p.m_next = this.rule();
            this.processStates(states, p.m_next);
        }
        return start;
    }

    private CNfa rule() throws IOException {
        CNfa start = null;
        CNfa end = null;
        int anchor = 0;
        CNfaPair pair = CAlloc.newCNfaPair();
        if (3 == this.m_spec.m_current_token) {
            start = CAlloc.newCNfa(this.m_spec);
            start.m_edge = 10;
            anchor |= 1;
            this.m_lexGen.advance();
            this.expr(pair);
            start.m_next = pair.m_start;
            end = pair.m_end;
        } else {
            this.expr(pair);
            start = pair.m_start;
            end = pair.m_end;
        }
        if (4 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            end.m_next = CAlloc.newCNfa(this.m_spec);
            end.m_edge = -1;
            end.m_set = new CSet();
            end.m_set.add(10);
            if (!this.m_spec.m_unix) {
                end.m_set.add(13);
            }
            end = end.m_next;
            anchor |= 2;
        }
        end.m_accept = this.m_lexGen.packAccept();
        end.m_anchor = anchor;
        return start;
    }

    private void expr(CNfaPair pair) throws IOException {
        CUtility.cuassert(pair != null);
        CNfaPair e2_pair = CAlloc.newCNfaPair();
        this.cat_expr(pair);
        while (16 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            this.cat_expr(e2_pair);
            CNfa p = CAlloc.newCNfa(this.m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            pair.m_end.m_next = p = CAlloc.newCNfa(this.m_spec);
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
        }
    }

    private void cat_expr(CNfaPair pair) throws IOException {
        CUtility.cuassert(pair != null);
        CNfaPair e2_pair = CAlloc.newCNfaPair();
        if (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(pair);
        }
        while (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(e2_pair);
            pair.m_end.mimic(e2_pair.m_start);
            this.discardCNfa(e2_pair.m_start);
            pair.m_end = e2_pair.m_end;
        }
    }

    private boolean first_in_cat(int token) {
        switch (token) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                return false;
            }
            case 9: 
            case 15: 
            case 17: {
                CError.parse_error(5, this.m_input.m_line_number);
                return false;
            }
            case 5: {
                CError.parse_error(3, this.m_input.m_line_number);
                return false;
            }
            case 3: {
                CError.parse_error(4, this.m_input.m_line_number);
                return false;
            }
        }
        return true;
    }

    private void factor(CNfaPair pair) throws IOException {
        CNfa start = null;
        CNfa end = null;
        this.term(pair);
        if (9 == this.m_spec.m_current_token || 17 == this.m_spec.m_current_token || 15 == this.m_spec.m_current_token) {
            start = CAlloc.newCNfa(this.m_spec);
            end = CAlloc.newCNfa(this.m_spec);
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;
            if (9 == this.m_spec.m_current_token || 15 == this.m_spec.m_current_token) {
                start.m_next2 = end;
            }
            if (9 == this.m_spec.m_current_token || 17 == this.m_spec.m_current_token) {
                pair.m_end.m_next2 = pair.m_start;
            }
            pair.m_start = start;
            pair.m_end = end;
            this.m_lexGen.advance();
        }
    }

    private void term(CNfaPair pair) throws IOException {
        if (14 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            this.expr(pair);
            if (8 == this.m_spec.m_current_token) {
                this.m_lexGen.advance();
            } else {
                CError.parse_error(16, this.m_input.m_line_number);
            }
        } else {
            CNfa start;
            pair.m_start = start = CAlloc.newCNfa(this.m_spec);
            pair.m_end = start.m_next = CAlloc.newCNfa(this.m_spec);
            boolean isAlphaL = 12 == this.m_spec.m_current_token && Character.isLetter(this.m_spec.m_lexeme);
            if (!(2 == this.m_spec.m_current_token || 6 == this.m_spec.m_current_token || this.m_spec.m_ignorecase && isAlphaL)) {
                start.m_edge = this.m_spec.m_lexeme;
                this.m_lexGen.advance();
            } else {
                start.m_edge = -1;
                start.m_set = new CSet();
                if (this.m_spec.m_ignorecase && isAlphaL) {
                    start.m_set.addncase(this.m_spec.m_lexeme);
                } else if (2 == this.m_spec.m_current_token) {
                    start.m_set.add(10);
                    if (!this.m_spec.m_unix) {
                        start.m_set.add(13);
                    }
                    start.m_set.complement();
                } else {
                    this.m_lexGen.advance();
                    if (3 == this.m_spec.m_current_token) {
                        this.m_lexGen.advance();
                        start.m_set.complement();
                    }
                    if (5 != this.m_spec.m_current_token) {
                        this.dodash(start.m_set);
                    }
                }
                this.m_lexGen.advance();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void dodash(CSet set) throws IOException {
        first = -1;
        while (1 != this.m_spec.m_current_token && 5 != this.m_spec.m_current_token) {
            block7: {
                block6: {
                    if (10 != this.m_spec.m_current_token || -1 == first) break block6;
                    this.m_lexGen.advance();
                    if (this.m_spec.m_current_token != 5) ** GOTO lbl14
                    set.add(45);
                    break;
lbl-1000:
                    // 1 sources

                    {
                        if (this.m_spec.m_ignorecase) {
                            set.addncase((char)first);
                        } else {
                            set.add(first);
                        }
                        ++first;
lbl14:
                        // 2 sources

                        ** while (first <= this.m_spec.m_lexeme)
                    }
lbl15:
                    // 1 sources

                    break block7;
                }
                first = this.m_spec.m_lexeme;
                if (this.m_spec.m_ignorecase) {
                    set.addncase(this.m_spec.m_lexeme);
                } else {
                    set.add(this.m_spec.m_lexeme);
                }
            }
            this.m_lexGen.advance();
        }
    }
}

