/*
 * Decompiled with CFR 0.152.
 */
package diva.util.xml;

import diva.util.xml.XmlDocument;
import diva.util.xml.XmlReader;
import diva.util.xml.XmlWriter;
import java.io.File;
import java.io.OutputStreamWriter;

public class XmlDemo {
    public static void main(String[] argv) {
        File file = new File("xml1.xml");
        System.out.println("We are going to parse from " + file + ".");
        System.out.println("The parser will be set to verbose mode\n");
        XmlDocument document = new XmlDocument(file);
        XmlReader reader = new XmlReader();
        reader.setVerbose(true);
        try {
            reader.parse(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int errors = reader.getErrorCount();
        int warnings = reader.getWarningCount();
        System.err.println("Completed: " + errors + " errors, " + warnings + " warnings");
        if (errors > 0) {
            System.err.println("Unrecoverable errors in XML. Stop.");
            return;
        }
        System.out.println("\nHaving parsed the document, we will print it out.");
        System.out.println("Here is the DTD:\n");
        XmlWriter writer = new XmlWriter();
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        try {
            writer.writeDTD(document, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nHere is the XML:\n");
        try {
            writer.write(document, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

