/*
 * Decompiled with CFR 0.152.
 */
package diva.util.jester;

import diva.util.jester.TestCase;
import diva.util.jester.TestFailedException;
import diva.util.jester.TestSuite;
import java.io.PrintStream;

public class TestHarness {
    private PrintStream _outputStream = System.out;
    private int _indentLevel = 0;
    private String _indentString = "";

    public void runTestCase(TestCase testCase) {
        this.printnoln(testCase.getName());
        try {
            testCase.init();
        }
        catch (Exception e) {
            this.println("\nInitialization aborted: ");
            this.println("    " + testCase.toString());
            this.println("    " + e.getMessage());
            this.println("Stack trace: ");
            e.printStackTrace(this._outputStream);
            return;
        }
        try {
            testCase.run();
        }
        catch (Exception e) {
            this.println("\nTest case aborted: ");
            this.println("    " + testCase.toString());
            this.println("    " + e.getMessage());
            this.println("Stack trace: ");
            e.printStackTrace(this._outputStream);
            return;
        }
        try {
            testCase.check();
        }
        catch (TestFailedException e) {
            this.println("\nTest failed: ");
            this.println("    " + testCase.toString());
            this.println("    " + e.getMessage());
            return;
        }
        catch (Exception e) {
            this.println("\nTest check aborted: ");
            this.println("    " + testCase.toString());
            this.println("    " + e.getMessage());
            this.println("Stack trace: ");
            e.printStackTrace(this._outputStream);
        }
        if (testCase.getExecutionTime() > 0) {
            this.print(" (" + testCase.getExecutionTime() + " ms)\n");
        } else {
            this.print("\n");
        }
    }

    void readyTestSuite(TestSuite suite) {
        Object factory = suite.getFactory();
        String suiteClass = suite.getClass().getName();
        int index = suiteClass.lastIndexOf(".");
        suiteClass = suiteClass.substring(index + 1);
        if (factory == null) {
            this.println(suiteClass);
        } else {
            this.println(String.valueOf(suiteClass) + ": " + suite.getFactory().toString());
        }
        ++this._indentLevel;
        this._indentString = String.valueOf(this._indentString) + "    ";
    }

    void doneTestSuite() {
        --this._indentLevel;
        this._indentString = this._indentString.substring(4);
    }

    public void setOutputStream(PrintStream s) {
        this._outputStream = s;
    }

    void println(String s) {
        this._outputStream.print(this._indentString);
        this._outputStream.println(s);
    }

    void printnoln(String s) {
        this._outputStream.print(this._indentString);
        this._outputStream.print(s);
    }

    void print(String s) {
        this._outputStream.print(s);
    }
}

