/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.layout.RandomLayout;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RandomIncrLayout
implements IncrementalLayout {
    private RandomLayout _global;
    private static final int NUM_ITER = 10;

    public RandomIncrLayout(LayoutTarget target) {
        this._global = new RandomLayout(target);
    }

    public void edgeDrawn(Object edge) {
    }

    public void edgeRouted(Object edge) {
    }

    public void nodeDrawn(Object node) {
        if (this.getLayoutTarget().isNodeVisible(node)) {
            Rectangle2D vp = this.getLayoutTarget().getViewport(this.getLayoutTarget().getGraphModel().getParent(node));
            Rectangle2D bounds = this.getLayoutTarget().getBounds(node);
            int i = 0;
            while (i < 10) {
                double x = vp.getX() + Math.abs(Math.random()) * vp.getWidth();
                double y = vp.getY() + Math.abs(Math.random()) * vp.getHeight();
                LayoutUtilities.place(this.getLayoutTarget(), node, x, y);
                bounds = this.getLayoutTarget().getBounds(node);
                boolean overlap = false;
                Iterator j = this.getLayoutTarget().intersectingNodes(bounds);
                while (j.hasNext()) {
                    Object n2 = j.next();
                    if (node == n2) continue;
                    overlap = false;
                }
                if (!overlap) break;
                ++i;
            }
        }
    }

    public void nodeMoved(Object node) {
    }

    public LayoutTarget getLayoutTarget() {
        return this._global.getLayoutTarget();
    }

    public void setLayoutTarget(LayoutTarget target) {
        this._global.setLayoutTarget(target);
    }

    public void layout(Object composite) {
        this._global.layout(composite);
    }
}

