/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.interactor.Geometry;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PathGeometry
implements Geometry {
    private Figure _parentFigure;
    private Shape _path;
    private Vertex[] _vertices;
    private boolean _geometryValid = false;
    private int _vertexCount;
    private int _coordCount;
    private float[] _coordinate = new float[4];
    private int[] _type = new int[2];
    private int[] _index = new int[2];
    private AffineTransform _unitTransform = new AffineTransform();

    public PathGeometry(Figure figure, Shape shape) {
        this._parentFigure = figure;
        this._path = shape;
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public Shape getShape() {
        if (this._path == null) {
            GeneralPath p = new GeneralPath(1, this._vertexCount + 2);
            int c = 0;
            int i = 0;
            while (i < this._vertexCount) {
                switch (this._type[i]) {
                    case 4: {
                        p.closePath();
                        break;
                    }
                    case 0: {
                        p.moveTo(this._coordinate[c], this._coordinate[c + 1]);
                        c += 2;
                        break;
                    }
                    case 1: {
                        p.lineTo(this._coordinate[c], this._coordinate[c + 1]);
                        c += 2;
                        break;
                    }
                    case 2: {
                        p.quadTo(this._coordinate[c], this._coordinate[c + 1], this._coordinate[c + 2], this._coordinate[c + 3]);
                        c += 4;
                        break;
                    }
                    case 3: {
                        p.curveTo(this._coordinate[c], this._coordinate[c + 1], this._coordinate[c + 2], this._coordinate[c + 3], this._coordinate[c + 4], this._coordinate[c + 5]);
                        c += 6;
                    }
                }
                ++i;
            }
            this._path = p;
        }
        return this._path;
    }

    public Site getVertex(int number) {
        if (!this._geometryValid) {
            this.updateGeometry();
        }
        if (this._vertices[number] == null) {
            this._vertices[number] = this._type[number] == 4 ? new CloseSegment(number) : new Vertex(number);
        }
        return this._vertices[number];
    }

    public int getVertexCount() {
        if (!this._geometryValid) {
            this.updateGeometry();
        }
        return this._vertexCount;
    }

    public void setShape(Shape shape) {
        this._path = shape;
        this.invalidateGeometry();
    }

    public void translate(double x, double y) {
        if (!this._geometryValid) {
            this.updateGeometry();
        }
        int i = 0;
        while (i < this._coordCount) {
            int n = i++;
            this._coordinate[n] = (float)((double)this._coordinate[n] + x);
            int n2 = i++;
            this._coordinate[n2] = (float)((double)this._coordinate[n2] + y);
        }
    }

    public Iterator vertices() {
        if (!this._geometryValid) {
            this.updateGeometry();
        }
        return new Iterator(){
            int cursor = 0;
            int control_point = 0;

            public boolean hasNext() {
                return this.cursor < PathGeometry.this._vertexCount;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Can't get " + this.cursor + "'th element from PathyGeometry of size " + PathGeometry.this._vertexCount);
                }
                if (PathGeometry.this._vertices[this.cursor] == null) {
                    PathGeometry.this.getVertex(this.cursor);
                }
                switch (PathGeometry.this._type[this.cursor]) {
                    case 3: {
                        if (this.control_point == 0) {
                            this.control_point = 1;
                            return new Vertex(this.cursor, this.control_point);
                        }
                        if (this.control_point == 1) {
                            this.control_point = 2;
                            return new Vertex(this.cursor, this.control_point);
                        }
                        this.control_point = 0;
                        return PathGeometry.this._vertices[this.cursor++];
                    }
                    case 2: {
                        if (this.control_point == 0) {
                            this.control_point = 1;
                            return new Vertex(this.cursor, this.control_point);
                        }
                        this.control_point = 0;
                        return PathGeometry.this._vertices[this.cursor++];
                    }
                }
                return PathGeometry.this._vertices[this.cursor++];
            }

            public void remove() {
                throw new UnsupportedOperationException("Vertex sites cannot be removed");
            }
        };
    }

    private void invalidateGeometry() {
        this._geometryValid = false;
    }

    private void updateGeometry() {
        this._vertexCount = 0;
        this._coordCount = 0;
        this._vertices = null;
        float[] segment = new float[6];
        PathIterator i = this._path.getPathIterator(this._unitTransform);
        while (!i.isDone()) {
            if (this._vertexCount == this._type.length) {
                int[] temp1 = new int[this._type.length * 2];
                int[] temp2 = new int[this._type.length * 2];
                System.arraycopy(this._type, 0, temp1, 0, this._vertexCount);
                System.arraycopy(this._index, 0, temp2, 0, this._vertexCount);
                this._type = temp1;
                this._index = temp2;
            }
            if (this._coordCount + 6 > this._coordinate.length) {
                float[] temp = new float[this._coordinate.length * 2];
                System.arraycopy(this._coordinate, 0, temp, 0, this._coordCount);
                this._coordinate = temp;
            }
            this._index[this._vertexCount] = this._coordCount;
            this._type[this._vertexCount] = i.currentSegment(segment);
            switch (this._type[this._vertexCount]) {
                case 0: {
                    this._coordinate[this._coordCount++] = segment[0];
                    this._coordinate[this._coordCount++] = segment[1];
                    break;
                }
                case 1: {
                    this._coordinate[this._coordCount++] = segment[0];
                    this._coordinate[this._coordCount++] = segment[1];
                    break;
                }
                case 2: {
                    this._coordinate[this._coordCount++] = segment[0];
                    this._coordinate[this._coordCount++] = segment[1];
                    this._coordinate[this._coordCount++] = segment[2];
                    this._coordinate[this._coordCount++] = segment[3];
                    break;
                }
                case 3: {
                    this._coordinate[this._coordCount++] = segment[0];
                    this._coordinate[this._coordCount++] = segment[1];
                    this._coordinate[this._coordCount++] = segment[2];
                    this._coordinate[this._coordCount++] = segment[3];
                    this._coordinate[this._coordCount++] = segment[4];
                    this._coordinate[this._coordCount++] = segment[5];
                }
            }
            ++this._vertexCount;
            i.next();
        }
        this._vertices = new Vertex[this._vertexCount];
        this._geometryValid = true;
    }

    public class CloseSegment
    extends Vertex {
        CloseSegment(int id) {
            super(id);
        }

        public double getX() {
            if (!PathGeometry.this._geometryValid) {
                PathGeometry.this.updateGeometry();
            }
            return PathGeometry.this._coordinate[PathGeometry.this._index[this.getID()]];
        }

        public double getY() {
            if (!PathGeometry.this._geometryValid) {
                PathGeometry.this.updateGeometry();
            }
            return PathGeometry.this._coordinate[PathGeometry.this._index[this.getID()] + 1];
        }

        public void setPoint(Point2D point) {
            this.translate(point.getX() - this.getX(), point.getY() - this.getY());
        }

        public void translate(double x, double y) {
            throw new UnsupportedOperationException("Cannot translate close segments of a path");
        }
    }

    public class Vertex
    extends AbstractSite {
        private int _id;
        private int _controlPoint;

        Vertex(int id) {
            this._id = id;
            this._controlPoint = 0;
        }

        Vertex(int id, int control_point) {
            this._id = id;
            this._controlPoint = control_point;
        }

        public int getID() {
            return this._id;
        }

        public int getControlPoint() {
            return this._controlPoint;
        }

        public Figure getFigure() {
            return PathGeometry.this._parentFigure;
        }

        public double getX() {
            if (!PathGeometry.this._geometryValid) {
                PathGeometry.this.updateGeometry();
            }
            if (this._controlPoint == 0) {
                return PathGeometry.this._coordinate[PathGeometry.this._index[this._id]];
            }
            if (this._controlPoint == 1) {
                return PathGeometry.this._coordinate[PathGeometry.this._index[this._id] + 2];
            }
            return PathGeometry.this._coordinate[PathGeometry.this._index[this._id] + 4];
        }

        public double getY() {
            if (!PathGeometry.this._geometryValid) {
                PathGeometry.this.updateGeometry();
            }
            if (this._controlPoint == 0) {
                return PathGeometry.this._coordinate[PathGeometry.this._index[this._id] + 1];
            }
            if (this._controlPoint == 1) {
                return PathGeometry.this._coordinate[PathGeometry.this._index[this._id] + 3];
            }
            return PathGeometry.this._coordinate[PathGeometry.this._index[this._id] + 5];
        }

        public void setPoint(Point2D point) {
            this.translate(point.getX() - this.getX(), point.getY() - this.getY());
        }

        public void translate(double x, double y) {
            if (!PathGeometry.this._geometryValid) {
                PathGeometry.this.updateGeometry();
            }
            int index = PathGeometry.this._index[this._id];
            if (this._controlPoint == 0) {
                float[] fArray = PathGeometry.this._coordinate;
                int n = index;
                fArray[n] = (float)((double)fArray[n] + x);
                float[] fArray2 = PathGeometry.this._coordinate;
                int n2 = index + 1;
                fArray2[n2] = (float)((double)fArray2[n2] + y);
            } else if (this._controlPoint == 1) {
                float[] fArray = PathGeometry.this._coordinate;
                int n = index + 2;
                fArray[n] = (float)((double)fArray[n] + x);
                float[] fArray3 = PathGeometry.this._coordinate;
                int n3 = index + 3;
                fArray3[n3] = (float)((double)fArray3[n3] + y);
            } else {
                float[] fArray = PathGeometry.this._coordinate;
                int n = index + 4;
                fArray[n] = (float)((double)fArray[n] + x);
                float[] fArray4 = PathGeometry.this._coordinate;
                int n4 = index + 5;
                fArray4[n4] = (float)((double)fArray4[n4] + y);
            }
            PathGeometry.this._path = null;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(this.getClass().getName());
            s.append(": vertex " + this._id + " of " + PathGeometry.this._vertexCount);
            s.append(", type ");
            switch (PathGeometry.this._type[this._id]) {
                case 4: {
                    s.append("close");
                    break;
                }
                case 0: {
                    s.append("move");
                    break;
                }
                case 1: {
                    s.append("line");
                    break;
                }
                case 2: {
                    s.append("quadratic");
                    break;
                }
                case 3: {
                    s.append("cubic");
                }
            }
            return s.toString();
        }
    }
}

