/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.Interactor;
import java.util.ArrayList;
import java.util.Iterator;

public class CompositeInteractor
extends AbstractInteractor {
    private ArrayList _interactors = new ArrayList();
    private Interactor _currentInteractor;

    public boolean accept(LayerEvent e) {
        Iterator i = this.interactors();
        while (i.hasNext()) {
            if (!((Interactor)i.next()).accept(e)) continue;
            return true;
        }
        return false;
    }

    public void addInteractor(Interactor i) {
        this._interactors.add(i);
    }

    public Iterator interactors() {
        return this._interactors.iterator();
    }

    public boolean isMotionEnabled() {
        Iterator i = this.interactors();
        while (i.hasNext()) {
            if (!((Interactor)i.next()).isMotionEnabled()) continue;
            return true;
        }
        return false;
    }

    public void mouseDragged(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._currentInteractor != null) {
            this._currentInteractor.mouseDragged(event);
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mouseEntered(LayerEvent event) {
        if (!this.isMotionEnabled()) {
            return;
        }
        for (Interactor interactor : this._interactors) {
            if (!interactor.accept(event)) continue;
            this._currentInteractor = interactor;
            this._currentInteractor.mouseEntered(event);
            break;
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mouseExited(LayerEvent event) {
        if (!this.isMotionEnabled()) {
            return;
        }
        if (this._currentInteractor != null) {
            this._currentInteractor.mouseExited(event);
        }
        if (this.isConsuming()) {
            event.consume();
        }
        this._currentInteractor = null;
    }

    public void mouseMoved(LayerEvent event) {
        if (!this.isMotionEnabled()) {
            return;
        }
        if (this._currentInteractor != null) {
            this._currentInteractor.mouseMoved(event);
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mousePressed(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        for (Interactor interactor : this._interactors) {
            if (!interactor.accept(event)) continue;
            this._currentInteractor = interactor;
            this._currentInteractor.mousePressed(event);
            if (event.isConsumed()) break;
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mouseReleased(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._currentInteractor != null) {
            this._currentInteractor.mouseReleased(event);
        }
        if (this.isConsuming()) {
            event.consume();
        }
        this._currentInteractor = null;
    }

    public void removeInteractor(Interactor i) {
        this._interactors.remove(i);
    }
}

