/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;

public class AvailableIUElement
extends QueriedElement
implements IIUElement {
    IInstallableUnit iu;
    boolean shouldShowChildren = Policy.getDefault().getQueryContext().getShowAvailableChildren();
    boolean isInstalled = false;
    boolean isUpdate = false;
    private static boolean shouldShowSize = false;
    long size = -1L;
    String profileID;
    static /* synthetic */ Class class$0;

    public AvailableIUElement(Object parent, IInstallableUnit iu, String profileID, boolean showChildren) {
        super(parent);
        this.iu = iu;
        this.profileID = profileID;
        this.shouldShowChildren = showChildren;
    }

    protected String getImageId(Object obj) {
        if (this.isUpdate) {
            return "obj/iu_update_obj.gif";
        }
        if (this.isInstalled) {
            return "obj/iu_disabled_obj.gif";
        }
        return "obj/iu_obj.gif";
    }

    public String getLabel(Object o) {
        return this.iu.getId();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.iu;
        }
        return super.getAdapter(adapter);
    }

    public long getSize() {
        return this.size;
    }

    public void computeSize(IProgressMonitor monitor) {
        if (this.profileID == null) {
            return;
        }
        try {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ProvisioningPlan plan = this.getSizingPlan((IProgressMonitor)mon.newChild(50));
            this.size = ProvisioningUtil.getSize(plan, this.profileID, this.getProvisioningContext(), (IProgressMonitor)mon.newChild(50));
        }
        catch (ProvisionException e) {
            this.handleException((Exception)((Object)e), ProvUIMessages.AvailableIUElement_ProfileNotFound);
            this.size = -2L;
        }
    }

    protected IProfile getProfile() throws ProvisionException {
        return ProvisioningUtil.getProfile(this.profileID);
    }

    protected ProvisioningPlan getSizingPlan(IProgressMonitor monitor) throws ProvisionException {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.profileID);
        request.addInstallableUnits(new IInstallableUnit[]{this.getIU()});
        return ProvisioningUtil.getProvisioningPlan(request, this.getProvisioningContext(), monitor);
    }

    public IInstallableUnit getIU() {
        return this.iu;
    }

    public boolean shouldShowSize() {
        return shouldShowSize;
    }

    public boolean shouldShowVersion() {
        return true;
    }

    protected int getDefaultQueryType() {
        return 4;
    }

    public IRequiredCapability[] getRequirements() {
        return this.iu.getRequiredCapabilities();
    }

    public boolean shouldShowChildren() {
        return this.shouldShowChildren;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableIUElement)) {
            return false;
        }
        if (this.iu == null) {
            return false;
        }
        return this.iu.equals((Object)((AvailableIUElement)obj).getIU());
    }

    public int hashCode() {
        if (this.iu == null) {
            return 0;
        }
        return this.iu.hashCode();
    }

    public String toString() {
        if (this.iu == null) {
            return "NULL";
        }
        return this.iu.toString();
    }

    public void setIsInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    private ProvisioningContext getProvisioningContext() {
        if (this.hasQueryable() && this.getQueryable() instanceof IRepository) {
            return new ProvisioningContext(new URI[]{((IRepository)this.getQueryable()).getLocation()});
        }
        return new ProvisioningContext();
    }
}

