/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pf.util.MapWrapper;

public class StackedMap
extends MapWrapper {
    private StackedMap parentMap = null;

    protected StackedMap parentMap() {
        return this.parentMap;
    }

    protected void parentMap(StackedMap newValue) {
        this.parentMap = newValue;
    }

    public StackedMap() {
    }

    public StackedMap(Map map) {
        super(map);
    }

    protected StackedMap(StackedMap parent, Map valueMap) {
        this.parentMap(parent);
        this.internalMap(valueMap);
    }

    public void clear() {
        super.clear();
    }

    public boolean containsKey(Object key) {
        boolean found = super.containsKey(key);
        if (!found && this.hasParent()) {
            found = this.parentMap().containsKey(key);
        }
        return found;
    }

    public boolean containsValue(Object value) {
        boolean found = super.containsValue(value);
        if (!found && this.hasParent()) {
            found = this.parentMap().containsValue(value);
        }
        return found;
    }

    public Set entrySet() {
        Set set = super.entrySet();
        if (this.hasParent()) {
            set.addAll(this.parentMap().entrySet());
        }
        return set;
    }

    public Object get(Object key) {
        Object value = super.get(key);
        if (value == null && this.hasParent()) {
            value = this.parentMap().get(key);
        }
        return value;
    }

    public boolean isEmpty() {
        boolean empty = super.isEmpty();
        if (empty && this.hasParent()) {
            empty = this.parentMap().isEmpty();
        }
        return empty;
    }

    public Set keySet() {
        Set keys = super.keySet();
        if (this.hasParent()) {
            keys.addAll(this.parentMap().keySet());
        }
        return keys;
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Object remove(Object key) {
        return super.remove(key);
    }

    public int size() {
        int size = super.size();
        if (this.hasParent()) {
            size += this.parentMap().size();
        }
        return size;
    }

    public Collection values() {
        Collection values = super.values();
        if (this.hasParent()) {
            values.addAll(this.parentMap().values());
        }
        return values;
    }

    public void push(Map map) {
        StackedMap newParent = new StackedMap(this.parentMap(), this.internalMap());
        this.parentMap(newParent);
        this.internalMap(map == null ? this.createEmptyMap() : map);
    }

    public void push() {
        this.push(null);
    }

    public Map pop() {
        Map valueMap = this.internalMap();
        if (this.hasParent()) {
            this.internalMap(this.parentMap().internalMap());
            this.parentMap(this.parentMap().parentMap());
        }
        return valueMap;
    }

    protected Map createEmptyMap() {
        return new HashMap();
    }

    protected boolean hasParent() {
        return this.parentMap() != null;
    }
}

