/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.pf.util.CollectionUtil;
import org.pf.util.ObjectFilter;

public class ObjectCollectionFilter
implements ObjectFilter {
    protected static final boolean DEFAULT_USE_IDENTITY = false;
    private Collection objectCollection = null;
    private boolean useIdentity = false;
    private boolean negated = false;

    protected Collection getObjectCollection() {
        return this.objectCollection;
    }

    protected void setObjectCollection(Collection newValue) {
        this.objectCollection = newValue;
    }

    protected boolean getUseIdentity() {
        return this.useIdentity;
    }

    protected void setUseIdentity(boolean newValue) {
        this.useIdentity = newValue;
    }

    protected boolean getNegated() {
        return this.negated;
    }

    protected void setNegated(boolean newValue) {
        this.negated = newValue;
    }

    public ObjectCollectionFilter(Collection objects) {
        if (objects == null) {
            this.setObjectCollection(this.newCollection(0));
        } else {
            this.setObjectCollection(this.newCollection(objects.size()));
            this.getObjectCollection().addAll(objects);
        }
    }

    public ObjectCollectionFilter(Collection objects, boolean identity) {
        this(objects);
        this.setUseIdentity(identity);
    }

    public ObjectCollectionFilter(Object[] objects) {
        if (objects == null) {
            this.setObjectCollection(this.newCollection(0));
        } else {
            this.setObjectCollection(CollectionUtil.current().toList(objects));
        }
    }

    public ObjectCollectionFilter(Object[] objects, boolean identity) {
        this(objects);
        this.setUseIdentity(identity);
    }

    public boolean matches(Object object) {
        boolean matched = false;
        if (this.getObjectCollection() != null) {
            Iterator iter = this.getObjectCollection().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (this.getUseIdentity()) {
                    if (element != object) continue;
                    matched = true;
                    continue;
                }
                if (element == null) {
                    if (object != null) continue;
                    matched = true;
                    continue;
                }
                if (!element.equals(object)) continue;
                matched = true;
            }
        }
        return this.getNegated() ? !matched : matched;
    }

    public void negate() {
        this.setNegated(!this.getNegated());
    }

    protected Collection newCollection(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }
}

