/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.text.MatchRule;
import org.pf.text.MatchRuleChars;
import org.pf.text.MatchRuleVisitor;

public class MatchRulePrinter
implements MatchRuleVisitor {
    private StringBuffer buffer = null;
    private MatchRuleChars ruleChars = new MatchRuleChars();
    private boolean groupStarted = true;
    private boolean useNewSyntax = false;

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(StringBuffer newValue) {
        this.buffer = newValue;
    }

    protected MatchRuleChars getRuleChars() {
        return this.ruleChars;
    }

    protected void setRuleChars(MatchRuleChars newValue) {
        this.ruleChars = newValue;
    }

    protected boolean groupStarted() {
        return this.groupStarted;
    }

    protected void groupStarted(boolean newValue) {
        this.groupStarted = newValue;
    }

    public boolean useNewSyntax() {
        return this.useNewSyntax;
    }

    public void useNewSyntax(boolean newValue) {
        this.useNewSyntax = newValue;
    }

    public MatchRulePrinter() {
    }

    public MatchRulePrinter(MatchRuleChars ruleCharacters) {
        this();
        this.setRuleChars(ruleCharacters);
    }

    public void walkThroughInit() {
        this.setBuffer(new StringBuffer(100));
        this.groupStarted(true);
    }

    public void walkThroughFinished() {
    }

    public void startGroup(boolean andOperator, boolean notOperator) {
        this.appendOperators(andOperator, notOperator);
        this.getBuffer().append(this.getGroupStartChar());
        this.groupStarted(true);
    }

    public void endGroup() {
        this.getBuffer().append(this.getGroupEndChar());
        this.groupStarted(false);
    }

    public void attribute(String name, int compareOperator, String[] values, boolean andOperator, boolean notOperator) {
        this.appendOperators(andOperator, notOperator);
        this.getBuffer().append(name);
        if (this.useSetSyntax(compareOperator, values)) {
            this.appendValueList(values);
        } else {
            switch (compareOperator) {
                case 1: {
                    this.getBuffer().append(this.getRuleChars().getEqualsChar());
                    break;
                }
                case 2: {
                    this.getBuffer().append(this.getRuleChars().getGreaterChar());
                    break;
                }
                case 3: {
                    this.getBuffer().append(this.getRuleChars().getLessChar());
                    break;
                }
                case 4: {
                    this.getBuffer().append(this.getRuleChars().getGreaterChar());
                    this.getBuffer().append(this.getRuleChars().getEqualsChar());
                    break;
                }
                case 5: {
                    this.getBuffer().append(this.getRuleChars().getLessChar());
                    this.getBuffer().append(this.getRuleChars().getEqualsChar());
                }
            }
            this.appendValue(values[0]);
        }
        this.groupStarted(false);
    }

    public String asString(MatchRule matchRule) {
        if (matchRule == null) {
            return null;
        }
        matchRule.apply(this);
        String str = this.getBuffer().toString();
        if (!matchRule.getRootGroup().getNot()) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    protected void appendOperators(boolean andOperator, boolean notOperator) {
        if (!this.groupStarted()) {
            this.getBuffer().append(andOperator ? this.getAndChar() : this.getOrChar());
        }
        if (notOperator) {
            this.getBuffer().append(this.getNotChar());
        }
    }

    protected void appendValueList(String[] values) {
        this.getBuffer().append(this.getValueStartChar());
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                this.getBuffer().append(this.getValueSeparatorChar());
            }
            this.appendValue(values[i]);
            ++i;
        }
        this.getBuffer().append(this.getValueEndChar());
    }

    protected void appendValue(String value) {
        if (this.containsSpecialCharacter(value)) {
            this.getBuffer().append(this.getRuleChars().getValueDelimiterChar());
            this.getBuffer().append(value);
            this.getBuffer().append(this.getRuleChars().getValueDelimiterChar());
        } else {
            this.getBuffer().append(value);
        }
    }

    protected boolean useSetSyntax(int compareOperator, String[] values) {
        if (compareOperator == 1) {
            if (!this.useNewSyntax()) {
                return true;
            }
            if (values.length > 1) {
                return true;
            }
        }
        return false;
    }

    protected char getAndChar() {
        return this.getRuleChars().getAndChar();
    }

    protected void setAndChar(char newValue) {
        this.getRuleChars().setAndChar(newValue);
    }

    protected char getOrChar() {
        return this.getRuleChars().getOrChar();
    }

    protected void setOrChar(char newValue) {
        this.getRuleChars().setOrChar(newValue);
    }

    protected char getNotChar() {
        return this.getRuleChars().getNotChar();
    }

    protected void setNotChar(char newValue) {
        this.getRuleChars().setNotChar(newValue);
    }

    protected char getValueSeparatorChar() {
        return this.getRuleChars().getValueSeparatorChar();
    }

    protected void setValueSeparatorChar(char newValue) {
        this.getRuleChars().setValueSeparatorChar(newValue);
    }

    protected char getValueStartChar() {
        return this.getRuleChars().getValueStartChar();
    }

    protected void setValueStartChar(char newValue) {
        this.getRuleChars().setValueStartChar(newValue);
    }

    protected char getValueEndChar() {
        return this.getRuleChars().getValueEndChar();
    }

    protected void setValueEndChar(char newValue) {
        this.getRuleChars().setValueEndChar(newValue);
    }

    protected char getGroupStartChar() {
        return this.getRuleChars().getGroupStartChar();
    }

    protected void setGroupStartChar(char newValue) {
        this.getRuleChars().setGroupStartChar(newValue);
    }

    protected char getGroupEndChar() {
        return this.getRuleChars().getGroupEndChar();
    }

    protected void setGroupEndChar(char newValue) {
        this.getRuleChars().setGroupEndChar(newValue);
    }

    protected boolean containsSpecialCharacter(String value) {
        if (value.indexOf(this.getValueSeparatorChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getValueEndChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getValueStartChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getGroupStartChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getGroupEndChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getNotChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getAndChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getOrChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getRuleChars().getEqualsChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getRuleChars().getLessChar()) >= 0) {
            return true;
        }
        if (value.indexOf(this.getRuleChars().getGreaterChar()) >= 0) {
            return true;
        }
        if (value.indexOf(32) >= 0) {
            return true;
        }
        if (value.indexOf(9) >= 0) {
            return true;
        }
        if (value.indexOf(10) >= 0) {
            return true;
        }
        return value.indexOf(13) >= 0;
    }
}

