/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import org.pf.joi.ElementFilter;
import org.pf.joi.ImageProvider;

public class ElementFilterMenu {
    private ElementFilter elementFilter = new ElementFilter(24);
    private JCheckBoxMenuItem transientMenuItem = null;
    private JCheckBoxMenuItem staticMenuItem = null;
    private JCheckBoxMenuItem finalMenuItem = null;
    private JCheckBoxMenuItem privateMenuItem = null;
    private JCheckBoxMenuItem protectedMenuItem = null;
    private JCheckBoxMenuItem packageMenuItem = null;
    private JCheckBoxMenuItem publicMenuItem = null;

    protected ElementFilter getElementFilter() {
        return this.elementFilter;
    }

    protected void setElementFilter(ElementFilter aValue) {
        this.elementFilter = aValue;
    }

    protected JCheckBoxMenuItem getTransientMenuItem() {
        return this.transientMenuItem;
    }

    protected void setTransientMenuItem(JCheckBoxMenuItem newValue) {
        this.transientMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getStaticMenuItem() {
        return this.staticMenuItem;
    }

    protected void setStaticMenuItem(JCheckBoxMenuItem newValue) {
        this.staticMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getFinalMenuItem() {
        return this.finalMenuItem;
    }

    protected void setFinalMenuItem(JCheckBoxMenuItem newValue) {
        this.finalMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getPrivateMenuItem() {
        return this.privateMenuItem;
    }

    protected void setPrivateMenuItem(JCheckBoxMenuItem newValue) {
        this.privateMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getProtectedMenuItem() {
        return this.protectedMenuItem;
    }

    protected void setProtectedMenuItem(JCheckBoxMenuItem newValue) {
        this.protectedMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getPackageMenuItem() {
        return this.packageMenuItem;
    }

    protected void setPackageMenuItem(JCheckBoxMenuItem newValue) {
        this.packageMenuItem = newValue;
    }

    protected JCheckBoxMenuItem getPublicMenuItem() {
        return this.publicMenuItem;
    }

    protected void setPublicMenuItem(JCheckBoxMenuItem newValue) {
        this.publicMenuItem = newValue;
    }

    public ElementFilterMenu() {
        this.init();
    }

    public void replaceFilter(ElementFilter filter) {
        this.setElementFilter(filter);
        this.updateItems();
    }

    protected void init() {
        JCheckBoxMenuItem menuItem = this.createCheckMenuItem("Static", "ToggleStatic", null);
        this.setStaticMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Final", "ToggleFinal", null);
        this.setFinalMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Transient", "ToggleTransient", null);
        this.setTransientMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Private", "TogglePrivate", ImageProvider.instance().getPrivateIcon());
        this.setPrivateMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Protected", "ToggleProtected", ImageProvider.instance().getProtectedIcon());
        this.setProtectedMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Public", "TogglePublic", ImageProvider.instance().getPublicIcon());
        this.setPublicMenuItem(menuItem);
        menuItem = this.createCheckMenuItem("Default (Package)", "TogglePackage", ImageProvider.instance().getPackageIcon());
        this.setPackageMenuItem(menuItem);
        this.updateItems();
    }

    protected void updateItems() {
        this.getStaticMenuItem().setState(!this.getElementFilter().isStaticSet());
        this.getStaticMenuItem().repaint();
        this.getFinalMenuItem().setState(!this.getElementFilter().isFinalSet());
        this.getFinalMenuItem().repaint();
        this.getTransientMenuItem().setState(!this.getElementFilter().isTransientSet());
        this.getPrivateMenuItem().setState(!this.getElementFilter().isPrivateSet());
        this.getPrivateMenuItem().repaint();
        this.getProtectedMenuItem().setState(!this.getElementFilter().isProtectedSet());
        this.getPublicMenuItem().setState(!this.getElementFilter().isPublicSet());
        this.getPackageMenuItem().setState(!this.getElementFilter().isDefaultSet());
        this.getPackageMenuItem().repaint();
    }

    protected JCheckBoxMenuItem createCheckMenuItem(String text, String command, Icon icon) {
        JCheckBoxMenuItem menuItem = null;
        menuItem = icon == null ? new JCheckBoxMenuItem(text) : new JCheckBoxMenuItem(text, icon);
        menuItem.setActionCommand(command);
        return menuItem;
    }
}

