/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.pf.file.PropertiesFileElement;
import org.pf.text.StringPattern;
import org.pf.util.NamedText;
import org.pf.util.OrderedProperties;

public class PropertiesFileContent
extends OrderedProperties {
    private List commentIndex = null;

    protected List getCommentIndex() {
        return this.commentIndex;
    }

    protected void setCommentIndex(List newValue) {
        this.commentIndex = newValue;
    }

    public PropertiesFileContent() {
        this.setElements(new ArrayList(50));
        this.setPropertyIndex(new HashMap(50));
        this.setCommentIndex(new ArrayList(50));
    }

    public PropertiesFileContent(int initialCapacity) {
        super(initialCapacity);
        this.setCommentIndex(new ArrayList(initialCapacity));
    }

    public void addLine(String line) {
        if (line != null) {
            PropertiesFileElement element = new PropertiesFileElement(line);
            this.addElement(element);
        }
    }

    public Object setProperty(String name, String value) {
        PropertiesFileElement property = this.findPropertyElement(name);
        if (property == null) {
            this.appendProperty(name, value);
            return null;
        }
        String oldValue = property.text();
        property.changeValue(value);
        return oldValue;
    }

    public boolean modifyProperty(String name, String newValue) {
        PropertiesFileElement property = this.findPropertyElement(name);
        if (this.isNullOrDeleted(property)) {
            return false;
        }
        property.changeValue(newValue);
        return true;
    }

    public boolean addProperty(String name, String value) {
        PropertiesFileElement property = this.findPropertyElement(name);
        if (!this.isNullOrDeleted(property)) {
            return false;
        }
        return this.appendProperty(name, value);
    }

    public boolean commentProperty(String name) {
        PropertiesFileElement property = this.findPropertyElement(name);
        if (this.isNullOrDeleted(property)) {
            return false;
        }
        Integer index = this.indexOfProperty(name);
        this.getPropertyIndex().remove(name);
        boolean success = property.becomeComment();
        this.registerComment(index);
        return success;
    }

    public boolean uncommentProperty(String name) {
        StringPattern pattern = StringPattern.create("#*" + name + "*" + "=" + "*");
        Integer[] index = this.getCommentIndex().toArray(new Integer[0]);
        int i = 0;
        while (i < index.length) {
            PropertiesFileElement comment = this.elementAt(index[i]);
            if (pattern.matches(comment.getLine())) {
                this.getCommentIndex().remove(index[i]);
                boolean success = comment.becomeProperty();
                this.registerProperty(comment, index[i]);
                return success;
            }
            ++i;
        }
        return false;
    }

    protected NamedText newProperty(String name, String value) {
        return new PropertiesFileElement(name, value);
    }

    protected void addElement(NamedText element) {
        PropertiesFileElement propertyElement = (PropertiesFileElement)element;
        Integer index = new Integer(this.size());
        this.getElements().add(propertyElement);
        if (propertyElement.isProperty()) {
            this.registerProperty(propertyElement, index);
        } else if (propertyElement.isComment()) {
            this.registerComment(index);
        }
    }

    protected PropertiesFileElement findPropertyElement(String key) {
        return (PropertiesFileElement)this.findProperty(key);
    }

    protected PropertiesFileElement elementAt(Integer index) {
        return this.elementAt((int)index);
    }

    protected PropertiesFileElement elementAt(int index) {
        return (PropertiesFileElement)this.propertyAt(index);
    }

    protected void registerComment(Integer index) {
        this.getCommentIndex().add(index);
    }

    protected boolean isValidProperty(NamedText property) {
        if (property instanceof PropertiesFileElement) {
            PropertiesFileElement prop = (PropertiesFileElement)property;
            return prop.isProperty();
        }
        return super.isValidProperty(property);
    }
}

