/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.codecoverage.PyCoverage;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonRunnerConfig {
    public static final String RUN_COVERAGE = "python code coverage run";
    public static final String RUN_REGULAR = "python regular run";
    public static final String RUN_UNITTEST = "pyton unittest run";
    public static final String RUN_JYTHON_UNITTEST = "jython unittest run";
    public static final String RUN_JYTHON = "jython regular run";
    public static final String RUN_IRONPYTHON = "iron python regular run";
    public static final String RUN_IRONPYTHON_UNITTEST = "iron python unittest run";
    public final IProject project;
    public final IPath[] resource;
    public final IPath interpreter;
    public final IInterpreterInfo interpreterLocation;
    private final String arguments;
    public final File workingDirectory;
    public final String pythonpathUsed;
    public final boolean isDebug;
    public final boolean isInteractive;
    public int acceptTimeout = 5000;
    public String[] envp = null;
    private final boolean useUnittestWrapper;
    public final String run;
    private final ILaunchConfiguration configuration;
    private ListenConnector listenConnector;

    public boolean isCoverage() {
        return this.run.equals(RUN_COVERAGE);
    }

    public boolean isUnittest() {
        return this.run.equals(RUN_UNITTEST) || this.run.equals(RUN_JYTHON_UNITTEST) || this.run.equals(RUN_IRONPYTHON_UNITTEST);
    }

    public boolean isJython() {
        return this.run.equals(RUN_JYTHON) || this.run.equals(RUN_JYTHON_UNITTEST);
    }

    public boolean isIronpython() {
        return this.run.equals(RUN_IRONPYTHON) || this.run.equals(RUN_IRONPYTHON_UNITTEST);
    }

    public boolean isFile() throws CoreException {
        int resourceType = this.configuration.getAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", -1);
        return resourceType == 1;
    }

    public static IPath[] getLocation(ILaunchConfiguration configuration, IPythonNature nature) throws CoreException {
        String locationsStr = configuration.getAttribute("org.python.pydev.debug.core.ATTR_ALTERNATE_LOCATION", null);
        if (locationsStr == null) {
            locationsStr = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        if (locationsStr == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get location for run", null));
        }
        List locations = StringUtils.splitAndRemoveEmptyTrimmed((String)locationsStr, (char)'|');
        Path[] ret = new Path[locations.size()];
        int i = 0;
        for (String location : locations) {
            String expandedLocation = PythonRunnerConfig.getStringSubstitution(nature).performStringSubstitution(location);
            if (expandedLocation == null || expandedLocation.length() == 0) {
                throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get expanded location for run", null));
            }
            ret[i] = new Path(expandedLocation);
            ++i;
        }
        return ret;
    }

    public static String getArguments(ILaunchConfiguration configuration, boolean makeArgumentsVariableSubstitution) throws CoreException {
        String arguments = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
        if (makeArgumentsVariableSubstitution) {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        }
        return arguments;
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] res = DebugPlugin.parseArguments((String)arguments);
        return res;
    }

    private static StringSubstitution getStringSubstitution(IPythonNature nature) {
        return new StringSubstitution(nature);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration, IPythonNature nature) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = PythonRunnerConfig.getStringSubstitution(nature).performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Unable to get working location for the run \n(the location: '").append(expandedLocation).append("' is not a valid directory).").toString(), null));
        }
        return null;
    }

    public static IInterpreterInfo getInterpreterLocation(ILaunchConfiguration conf, IPythonNature nature, IInterpreterManager interpreterManager) throws InvalidRunException, CoreException, MisconfigurationException {
        String location = conf.getAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
        if (location != null && location.equals("__default")) {
            if (nature != null && nature.getInterpreterType() == interpreterManager.getInterpreterType()) {
                try {
                    return nature.getProjectInterpreter();
                }
                catch (PythonNatureWithoutProjectException e) {
                    throw new RuntimeException(e);
                }
            }
            return interpreterManager.getDefaultInterpreterInfo(null);
        }
        IInterpreterInfo interpreterInfo = interpreterManager.getInterpreterInfo(location, null);
        if (interpreterInfo != null) {
            return interpreterInfo;
        }
        File file = new File(location);
        if (!file.exists()) {
            throw new InvalidRunException(new StringBuffer("Error. The interprer: ").append(location).append(" does not exist").toString());
        }
        if (nature == null) {
            throw new InvalidRunException(new StringBuffer("Error. The interpreter: >>").append(location).append("<< is not configured in the pydev preferences as a valid interpreter (null nature).").toString());
        }
        throw new InvalidRunException(new StringBuffer("Error. The interpreter: >>").append(location).append("<< is not configured in the pydev preferences as a valid '").append(nature.getVersion()).append("' interpreter.").toString());
    }

    private IPath getInterpreter(IInterpreterInfo location, ILaunchConfiguration configuration, IPythonNature nature) throws CoreException, InvalidRunException {
        if (location == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get python interpreter for run", null));
        }
        String expandedLocation = PythonRunnerConfig.getStringSubstitution(nature).performStringSubstitution(location.getExecutableOrJar());
        if (expandedLocation == null || expandedLocation.length() == 0) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get expanded interpreter for run", null));
        }
        return new Path(expandedLocation);
    }

    public static IProject getProjectFromConfiguration(ILaunchConfiguration conf) throws CoreException {
        String projName = conf.getAttribute("org.python.pydev.debug.ATTR_PROJECT", "");
        if (projName == null || projName.length() == 0) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get project for the run", null));
        }
        IWorkspace w = ResourcesPlugin.getWorkspace();
        IProject p = w.getRoot().getProject(projName);
        if (p == null || !p.exists()) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Could not get project: ").append(projName).toString(), null));
        }
        return p;
    }

    public static String getPythonpathFromConfiguration(ILaunchConfiguration conf, IInterpreterManager manager) throws CoreException, InvalidRunException, MisconfigurationException {
        IProject p = PythonRunnerConfig.getProjectFromConfiguration(conf);
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)p);
        if (pythonNature == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Project should have a python nature: ").append(p.getName()).toString(), null));
        }
        IInterpreterInfo l = PythonRunnerConfig.getInterpreterLocation(conf, (IPythonNature)pythonNature, manager);
        return SimpleRunner.makePythonPathEnvString((IPythonNature)pythonNature, (IInterpreterInfo)l, (IInterpreterManager)manager);
    }

    public PythonRunnerConfig(ILaunchConfiguration conf, String mode, String run) throws CoreException, InvalidRunException, MisconfigurationException {
        this(conf, mode, run, true);
    }

    public PythonRunnerConfig(ILaunchConfiguration conf, String mode, String run, boolean makeArgumentsVariableSubstitution) throws CoreException, InvalidRunException, MisconfigurationException {
        this.project = PythonRunnerConfig.getProjectFromConfiguration(conf);
        if (this.project == null) {
            throw PydevPlugin.log((String)new StringBuffer("Could not get project for configuration: ").append(conf).toString());
        }
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)this.project);
        if (pythonNature == null) {
            CoreException e = PydevPlugin.log((String)new StringBuffer("No python nature for project: ").append(this.project.getName()).toString());
            throw e;
        }
        this.configuration = conf;
        this.run = run;
        this.isDebug = mode.equals("debug");
        this.isInteractive = mode.equals("interactive");
        this.useUnittestWrapper = !run.equals(RUN_UNITTEST) || !conf.getAttribute("org.python.pydev.debug.core.ATTR_NO_UNITTEST_WRAPPER", false);
        this.resource = PythonRunnerConfig.getLocation(conf, (IPythonNature)pythonNature);
        this.arguments = PythonRunnerConfig.getArguments(conf, makeArgumentsVariableSubstitution);
        IPath workingPath = PythonRunnerConfig.getWorkingDirectory(conf, (IPythonNature)pythonNature);
        this.workingDirectory = workingPath == null ? null : workingPath.toFile();
        this.acceptTimeout = PydevPrefs.getPreferences().getInt("CONNECT_TIMEOUT");
        this.interpreterLocation = PythonRunnerConfig.getInterpreterLocation(conf, (IPythonNature)pythonNature, this.getRelatedInterpreterManager());
        this.interpreter = this.getInterpreter(this.interpreterLocation, conf, (IPythonNature)pythonNature);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.envp = launchManager.getEnvironment(conf);
        IInterpreterManager manager = this.isJython() ? PydevPlugin.getJythonInterpreterManager() : (this.isIronpython() ? PydevPlugin.getIronpythonInterpreterManager() : PydevPlugin.getPythonInterpreterManager());
        boolean win32 = REF.isWindowsPlatform();
        if (this.envp == null) {
            this.envp = new SimplePythonRunner().getEnvironment((IPythonNature)pythonNature, this.interpreterLocation, manager);
        } else {
            Map envMap = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            String pythonpath = SimpleRunner.makePythonPathEnvString((IPythonNature)pythonNature, (IInterpreterInfo)this.interpreterLocation, (IInterpreterManager)manager);
            this.updateVar((IPythonNature)pythonNature, manager, win32, envMap, "PYTHONPATH", pythonpath);
            if (this.isJython()) {
                this.updateVar((IPythonNature)pythonNature, manager, win32, envMap, "CLASSPATH", pythonpath);
                this.updateVar((IPythonNature)pythonNature, manager, win32, envMap, "JYTHONPATH", pythonpath);
            } else if (this.isIronpython()) {
                this.updateVar((IPythonNature)pythonNature, manager, win32, envMap, "IRONPYTHONPATH", pythonpath);
            }
            this.envp = this.interpreterLocation.updateEnv(this.envp, envMap.keySet());
        }
        String p = "";
        String[] stringArray = this.envp;
        int n = this.envp.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Tuple tup = StringUtils.splitOnFirst((String)s, (char)'=');
            if (win32) {
                if (((String)tup.o1).toUpperCase().equals("PYTHONPATH")) {
                    p = (String)tup.o2;
                    break;
                }
            } else if (((String)tup.o1).equals("PYTHONPATH")) {
                p = (String)tup.o2;
                break;
            }
            ++n2;
        }
        this.pythonpathUsed = p;
    }

    private void updateVar(IPythonNature pythonNature, IInterpreterManager manager, boolean win32, Map envMap, String var, String pythonpath) {
        if (!this.specifiedEnvVar(envMap, var)) {
            boolean addPythonpath = true;
            int i = 0;
            while (i < this.envp.length) {
                if (win32) {
                    if (this.envp[i].toUpperCase().startsWith(new StringBuffer(String.valueOf(var)).append("=").toString())) {
                        this.envp[i] = new StringBuffer(String.valueOf(var)).append("=").append(pythonpath).toString();
                        addPythonpath = false;
                        break;
                    }
                } else if (this.envp[i].startsWith(new StringBuffer(String.valueOf(var)).append("=").toString())) {
                    this.envp[i] = new StringBuffer(String.valueOf(var)).append("=").append(pythonpath).toString();
                    addPythonpath = false;
                    break;
                }
                ++i;
            }
            if (addPythonpath) {
                String[] s = new String[this.envp.length + 1];
                System.arraycopy(this.envp, 0, s, 0, this.envp.length);
                s[s.length - 1] = new StringBuffer(String.valueOf(var)).append("=").append(pythonpath).toString();
                this.envp = s;
            }
        }
    }

    private boolean specifiedEnvVar(Map<String, String> envMap, String var) {
        if (envMap == null) {
            return false;
        }
        boolean win32 = Platform.getOS().equals("win32");
        if (!win32) {
            return envMap.containsKey(var);
        }
        var = var.toUpperCase();
        for (String s : envMap.keySet()) {
            if (!s.toUpperCase().equals(var)) continue;
            return true;
        }
        return false;
    }

    public String getProcessType() {
        return this.isJython() ? "java" : "PYDEV.PYTHON";
    }

    public static String getRunningName(IPath[] paths) {
        FastStringBuffer buf = new FastStringBuffer(20 * paths.length);
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(p.lastSegment());
            ++n2;
        }
        return buf.toString();
    }

    public String getRunningName() {
        return PythonRunnerConfig.getRunningName(this.resource);
    }

    public static String getCoverageScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("coverage.py"));
    }

    public static String getDebugScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("pydevd.py"));
    }

    public static String getRunFilesScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("runfiles.py"));
    }

    public String[] getCommandLine(boolean makeVariableSubstitution) throws CoreException, JDTNotAvailableException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (this.isJython()) {
            String javaLoc = JavaVmLocationFinder.findDefaultJavaExecutable().getAbsolutePath();
            if (!InterpreterInfo.isJythonExecutable((String)this.interpreter.toOSString())) {
                throw new RuntimeException(new StringBuffer("The jython jar must be specified as the interpreter to run. Found: ").append(this.interpreter).toString());
            }
            cmdArgs.add(javaLoc);
            cmdArgs.add("-classpath");
            String cpath = new StringBuffer().append(this.interpreter).append(SimpleRunner.getPythonPathSeparator()).append(this.pythonpathUsed).toString();
            cmdArgs.add(cpath);
            cmdArgs.add(new StringBuffer("-Dpython.path=").append(this.pythonpathUsed).toString());
            this.addVmArgs(cmdArgs);
            if (this.isDebug) {
                cmdArgs.add("org.python.util.jython");
                this.addDebugArgs(cmdArgs, "jython");
            } else {
                cmdArgs.add("org.python.util.jython");
            }
        } else {
            cmdArgs.add(this.interpreter.toOSString());
            cmdArgs.add("-u");
            this.addVmArgs(cmdArgs);
            if (this.isDebug && this.isIronpython()) {
                this.addIronPythonDebugVmArgs(cmdArgs);
            }
            this.addDebugArgs(cmdArgs, "python");
            if (this.isCoverage()) {
                cmdArgs.add(PythonRunnerConfig.getCoverageScript());
                String coverageFileLocation = PyCoverage.getCoverageFileLocation();
                cmdArgs.add(coverageFileLocation);
                cmdArgs.add("-x");
                if (!this.isFile()) {
                    cmdArgs.add(PythonRunnerConfig.getRunFilesScript());
                }
            }
        }
        this.addUnittestArgs(cmdArgs);
        IPath[] iPathArray = this.resource;
        int n = this.resource.length;
        int cpath = 0;
        while (cpath < n) {
            IPath p = iPathArray[cpath];
            cmdArgs.add(p.toOSString());
            ++cpath;
        }
        String[] runArguments = null;
        if (makeVariableSubstitution && this.arguments != null) {
            String expanded = PythonRunnerConfig.getStringSubstitution((IPythonNature)PythonNature.getPythonNature((IProject)this.project)).performStringSubstitution(this.arguments);
            runArguments = PythonRunnerConfig.parseStringIntoList(expanded);
        }
        int i = 0;
        while (runArguments != null && i < runArguments.length) {
            cmdArgs.add(runArguments[i]);
            ++i;
        }
        String[] retVal = new String[cmdArgs.size()];
        cmdArgs.toArray(retVal);
        return retVal;
    }

    private void addIronPythonDebugVmArgs(List<String> cmdArgs) {
        if (cmdArgs.contains("-X:Frames") || cmdArgs.contains("-X:FullFrames")) {
            return;
        }
        cmdArgs.add("-X:FullFrames");
    }

    private void addUnittestArgs(List<String> cmdArgs) throws CoreException {
        if (this.isUnittest() && this.useUnittestWrapper) {
            String tests;
            cmdArgs.add(PythonRunnerConfig.getRunFilesScript());
            cmdArgs.add("--verbosity");
            cmdArgs.add(PydevPrefs.getPreferences().getString("PYUNIT_VERBOSITY"));
            String filter = PydevPrefs.getPreferences().getString("PYUNIT_TEST_FILTER");
            if (filter.length() > 0) {
                cmdArgs.add("--filter");
                cmdArgs.add(filter);
            }
            if ((tests = this.configuration.getAttribute("org.python.pydev.debug.ATTR_UNITTEST_TESTS", "")).length() > 0) {
                cmdArgs.add("--tests");
                cmdArgs.add(tests);
            }
        }
    }

    private void addDebugArgs(List<String> cmdArgs, String vmType) throws CoreException {
        if (this.isDebug) {
            cmdArgs.add(PythonRunnerConfig.getDebugScript());
            cmdArgs.add("--vm_type");
            cmdArgs.add(vmType);
            cmdArgs.add("--client");
            cmdArgs.add("localhost");
            cmdArgs.add("--port");
            try {
                cmdArgs.add(Integer.toString(this.getListenConnector().getLocalPort()));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)PydevPlugin.makeStatus((int)4, (String)"Unable to get port", (Throwable)e));
            }
            cmdArgs.add("--file");
        }
    }

    private void addVmArgs(List<String> cmdArgs) throws CoreException {
        String[] vmArguments = this.getVMArguments(this.configuration);
        if (vmArguments != null) {
            int i = 0;
            while (i < vmArguments.length) {
                cmdArgs.add(vmArguments[i]);
                ++i;
            }
        }
    }

    private String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.python.pydev.debug.vm.arguments", null);
        if (args != null && args.trim().length() > 0) {
            String expanded = PythonRunnerConfig.getStringSubstitution((IPythonNature)PythonNature.getPythonNature((IProject)this.project)).performStringSubstitution(args);
            return PythonRunnerConfig.parseStringIntoList(expanded);
        }
        return null;
    }

    public String getCommandLineAsString() throws JDTNotAvailableException {
        try {
            String[] args = this.getCommandLine(false);
            return SimpleRunner.getArgumentsAsStr((String[])args, (String[])new String[0]);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        if (this.isJython()) {
            return PydevPlugin.getJythonInterpreterManager();
        }
        if (this.isIronpython()) {
            return PydevPlugin.getIronpythonInterpreterManager();
        }
        return PydevPlugin.getPythonInterpreterManager();
    }

    public synchronized ListenConnector getListenConnector() throws IOException {
        if (this.listenConnector == null) {
            this.listenConnector = new ListenConnector(this.acceptTimeout);
        }
        return this.listenConnector;
    }
}

