/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.search;

import com.python.pydev.ui.search.FileMatch;
import com.python.pydev.ui.search.ReplaceDialog2;
import com.python.pydev.ui.search.SearchAgainConfirmationDialog;
import com.python.pydev.ui.search.SearchMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;

class ReplaceAction2
extends Action {
    private IWorkbenchSite fSite;
    private IFile[] fElements;
    private FileSearchPage fPage;

    public ReplaceAction2(FileSearchPage page, IFile[] elements) {
        Assert.isNotNull((Object)page);
        this.fSite = page.getSite();
        this.fElements = elements != null ? elements : new IFile[0];
        this.fPage = page;
        this.setText(SearchMessages.ReplaceAction_label_all);
        this.setEnabled(this.fElements.length != 0);
    }

    public ReplaceAction2(FileSearchPage page) {
        Assert.isNotNull((Object)page);
        this.fSite = page.getSite();
        this.fPage = page;
        Item[] items = null;
        StructuredViewer viewer = this.fPage.getViewer();
        if (viewer instanceof TreeViewer) {
            items = ((TreeViewer)viewer).getTree().getItems();
        } else if (viewer instanceof TableViewer) {
            items = ((TableViewer)viewer).getTable().getItems();
        }
        this.fElements = this.collectFiles(new ItemIterator(items));
        this.setText(SearchMessages.ReplaceAction_label_all);
        this.setEnabled(this.fElements.length != 0);
    }

    public ReplaceAction2(FileSearchPage page, IStructuredSelection selection) {
        this.fSite = page.getSite();
        this.fPage = page;
        this.setText(SearchMessages.ReplaceAction_label_selected);
        this.fElements = this.collectFiles(selection.iterator());
        this.setEnabled(this.fElements.length != 0);
    }

    /*
     * Unable to fully structure code
     */
    private IFile[] collectFiles(Iterator resources) {
        files = new HashSet<E>();
        result = this.fPage.getInput();
        if (result != null) ** GOTO lbl11
        return new IFile[0];
lbl-1000:
        // 1 sources

        {
            resource = (IResource)resources.next();
            try {
                resource.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1) {
                            IResource file = proxy.requestResource();
                            if (result.getMatchCount((Object)file) > 0) {
                                files.add(file);
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
                continue;
            }
            catch (CoreException e) {
                SearchPlugin.getDefault().getLog().log(e.getStatus());
            }
lbl11:
            // 3 sources

            ** while (resources.hasNext())
        }
lbl12:
        // 1 sources

        return files.toArray(new IFile[files.size()]);
    }

    public void run() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot());
        try {
            try {
                Platform.getJobManager().beginRule(rule, null);
                if (this.validateResources((FileSearchQuery)this.fPage.getInput().getQuery())) {
                    ReplaceDialog2 dialog = new ReplaceDialog2(this.fSite.getShell(), this.fElements, this.fPage);
                    dialog.open();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                Platform.getJobManager().endRule(rule);
            }
        }
        finally {
            Platform.getJobManager().endRule(rule);
        }
    }

    private boolean validateResources(final FileSearchQuery operation) {
        IFile[] readOnlyFiles = this.getReadOnlyFiles();
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles, (Object)this.fSite.getShell());
        if (!status.isOK()) {
            if (status.getSeverity() != 8) {
                ErrorDialog.openError((Shell)this.fSite.getShell(), (String)SearchMessages.ReplaceAction2_error_validate_title, (String)SearchMessages.ReplaceAction2_error_validate_message, (IStatus)status);
            }
            return false;
        }
        final ArrayList<IFile> outOfDateEntries = new ArrayList<IFile>();
        int j = 0;
        while (j < this.fElements.length) {
            IFile entry = this.fElements[j];
            Match[] markers = this.fPage.getDisplayedMatches((Object)entry);
            int i = 0;
            while (i < markers.length) {
                if (this.isOutOfDate((FileMatch)markers[i])) {
                    outOfDateEntries.add(entry);
                    break;
                }
                ++i;
            }
            ++j;
        }
        ArrayList<IFile> outOfSyncEntries = new ArrayList<IFile>();
        int i = 0;
        while (i < this.fElements.length) {
            IFile entry = this.fElements[i];
            if (this.isOutOfSync(entry)) {
                outOfSyncEntries.add(entry);
            }
            ++i;
        }
        if (outOfDateEntries.size() > 0 || outOfSyncEntries.size() > 0) {
            if (this.askForResearch(outOfDateEntries, outOfSyncEntries)) {
                AsynchronousProgressMonitorDialog pmd = new AsynchronousProgressMonitorDialog(this.fSite.getShell());
                try {
                    pmd.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                            ReplaceAction2.this.research(monitor, outOfDateEntries, operation);
                        }
                    });
                    return true;
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.fSite.getShell(), (String)SearchMessages.ReplaceAction_label, (String)SearchMessages.ReplaceAction_research_error);
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }
        return true;
    }

    private IFile[] getReadOnlyFiles() {
        HashSet<IFile> readOnly = new HashSet<IFile>();
        int i = 0;
        while (i < this.fElements.length) {
            if (this.fElements[i].isReadOnly()) {
                readOnly.add(this.fElements[i]);
            }
            ++i;
        }
        IFile[] readOnlyArray = new IFile[readOnly.size()];
        return readOnly.toArray(readOnlyArray);
    }

    private void research(IProgressMonitor monitor, List outOfDateEntries, FileSearchQuery operation) throws CoreException {
        String message = SearchMessages.ReplaceAction2_statusMessage;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.search", 0, message, null);
        Iterator elements = outOfDateEntries.iterator();
        while (elements.hasNext()) {
            IFile entry = (IFile)elements.next();
            IStatus status = this.research(operation, monitor, entry);
            if (status == null || status.isOK()) continue;
            multiStatus.add(status);
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private boolean askForResearch(List outOfDateEntries, List outOfSyncEntries) {
        SearchAgainConfirmationDialog dialog = new SearchAgainConfirmationDialog(this.fSite.getShell(), (ILabelProvider)this.fPage.getViewer().getLabelProvider(), outOfSyncEntries, outOfDateEntries);
        return dialog.open() == 0;
    }

    private boolean isOutOfDate(FileMatch match) {
        if (match.getCreationTimeStamp() != match.getFile().getModificationStamp()) {
            return true;
        }
        ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fb = bm.getTextFileBuffer(match.getFile().getFullPath());
        return fb != null && fb.isDirty();
    }

    private boolean isOutOfSync(IFile entry) {
        return !entry.isSynchronized(0);
    }

    private IStatus research(FileSearchQuery operation, IProgressMonitor monitor, IFile entry) {
        Match[] matches = this.fPage.getDisplayedMatches((Object)entry);
        IStatus status = operation.searchInFile(this.getResult(), monitor, entry);
        int i = 0;
        while (i < matches.length) {
            this.getResult().removeMatch(matches[i]);
            ++i;
        }
        return status;
    }

    private AbstractTextSearchResult getResult() {
        return this.fPage.getInput();
    }

    private static class ItemIterator
    implements Iterator {
        private Item[] fArray;
        private int fNextPosition;

        ItemIterator(Item[] array) {
            this.fArray = array;
            this.fNextPosition = 0;
        }

        public boolean hasNext() {
            return this.fNextPosition < this.fArray.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.fArray[this.fNextPosition++].getData();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

