/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SRBRandomAccessFile
extends RemoteRandomAccessFile {
    static final int O_RDONLY = 0;
    static final int O_WRONLY = 1;
    static final int O_RDWR = 2;
    static final int O_APPEND = 1024;
    static final int O_SYNC = 4096;
    static final int O_DSYNC = 4096;
    long filePointer = 0L;
    SRBFileSystem fileSystem;

    public SRBRandomAccessFile(SRBFileSystem srbFileSystem, String filePath, String mode) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        this(new SRBFile(srbFileSystem, filePath), mode);
    }

    public SRBRandomAccessFile(SRBFile file, String mode) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(file, mode);
        this.swapNeeded = false;
        this.open(file);
        this.setFileSystem(file.getFileSystem());
    }

    protected void rwCheck(GeneralFile file, String mode) throws IllegalArgumentException, SecurityException {
        if ((mode = mode.toLowerCase()).equals("r")) {
            this.rw = 0;
        } else if (mode.equals("rw")) {
            this.rw = 1;
        } else if (mode.equals("rws")) {
            this.rw = 2;
        } else if (mode.equals("rwd")) {
            this.rw = 3;
        } else {
            throw new IllegalArgumentException("Illegal mode \"" + mode + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        if (!((SRBFile)file).canRead("isFile")) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
        if (this.rw > 0 && !((SRBFile)file).canWrite("isFile")) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
    }

    protected void open(GeneralFile file) throws FileNotFoundException, SecurityException, IOException {
        if (this.rw == 0) {
            this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 0, file.getParent());
        } else if (this.rw == 1) {
            this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 2, file.getParent());
        } else if (this.rw == 2) {
            this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 4096, file.getParent());
        } else if (this.rw == 3) {
            this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 4096, file.getParent());
        }
    }

    protected void setFileSystem(GeneralFileSystem fileSystem) throws IllegalArgumentException, ClassCastException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (SRBFileSystem)fileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    public int read() throws IOException {
        byte[] buffer = this.fileSystem.srbObjRead(this.fd, 1);
        if (buffer != null) {
            this.filePointer += (long)buffer.length;
            return buffer[0];
        }
        return -1;
    }

    protected int readBytes(byte[] buffer, int offset, int len) throws IOException {
        byte[] b = null;
        b = this.fileSystem.srbObjRead(this.fd, len);
        if (b != null) {
            System.arraycopy(b, 0, buffer, offset, b.length);
            this.filePointer += (long)b.length;
            return b.length;
        }
        return 0;
    }

    protected void writeBytes(byte[] buffer, int offset, int len) throws IOException {
        byte[] b = new byte[len];
        if (offset == 0) {
            this.filePointer += (long)this.fileSystem.srbObjWrite(this.fd, buffer, len);
        } else {
            System.arraycopy(buffer, offset, b, 0, len);
            this.filePointer += (long)this.fileSystem.srbObjWrite(this.fd, b, len);
        }
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileSystem.srbObjSeek(this.fd, position, 0);
        this.filePointer = position;
    }

    public void seek(long position, int origin) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileSystem.srbObjSeek(this.fd, position, origin);
        this.filePointer = position;
    }

    public long length() throws IOException {
        MetaDataRecordList[] rl = null;
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("size")};
        try {
            rl = this.fileSystem.query(conditions, selects, 3);
            if (rl != null) {
                return Long.parseLong(rl[0].getValue("size").toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    public void setLength(long newLength) throws IOException {
        long length = this.length();
        if (newLength > length) {
            this.seek(newLength - 1L);
            this.write(0);
        } else if (newLength < length) {
            throw new UnsupportedOperationException();
        }
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
        if (this.fileFormat != null) {
            this.fileFormat = null;
        }
    }

    public String toString() {
        switch (this.rw) {
            case 0: {
                return String.valueOf(this.file.getParent()) + "/" + this.file.getName() + " : r";
            }
            case 1: {
                return String.valueOf(this.file.getParent()) + "/" + this.file.getName() + " : rw";
            }
            case 2: {
                return String.valueOf(this.file.getParent()) + "/" + this.file.getName() + " : rws";
            }
            case 3: {
                return String.valueOf(this.file.getParent()) + "/" + this.file.getName() + " : rwd";
            }
        }
        return String.valueOf(this.file.getParent()) + "/" + this.file.getName();
    }
}

