/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.RemoteAccount;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SRBAccount
extends RemoteAccount {
    public static final int PASSWD_AUTH = 48;
    public static final int GSI_AUTH = 51;
    public static final int ENCRYPT1 = 53;
    public static final int GSI_DELEGATE = 54;
    public static final String SRB_VERSION_3_3_1 = "SRB-3.3.1jargon&G";
    public static final String SRB_VERSION_3_3 = "SRB-3.3jargon&G";
    public static final String SRB_VERSION_3_0_2 = "SRB-3.0.2jargon&F";
    public static final String SRB_VERSION_3 = "SRB-3.0.0jargon&E";
    public static final String SRB_VERSION_2 = "SRB2.0.0jargon&D";
    public static final String SRB_VERSION_1_1_8 = "SRB1.1.8jargon&C";
    protected String proxyUserName;
    protected String proxyDomainName;
    protected String domainName;
    protected String defaultStorageResource;
    protected int options = 53;
    protected String proxyMcatZone;
    protected String clientMcatZone;
    protected String execFile;
    protected String certificateAuthority;
    protected Object gssCredential;
    protected static String version = "SRB-3.3.1jargon&G";
    static HashMap versionNumber = new HashMap(10, 1.0f);

    static {
        versionNumber.put(SRB_VERSION_3_3_1, new Float(3.31));
        versionNumber.put(SRB_VERSION_3_3, new Float(3.3));
        versionNumber.put(SRB_VERSION_3_0_2, new Float(3.0f));
        versionNumber.put(SRB_VERSION_2, new Float(2.0f));
        versionNumber.put(SRB_VERSION_1_1_8, new Float(1.0f));
        String temp = System.getProperty("jargon.version", version);
        if (temp.startsWith("SRB-3.3.1") || temp.startsWith("SRB3.3.1") || temp.startsWith("3.3.1") || temp.startsWith("SRB-3.31") || temp.startsWith("SRB3.31") || temp.startsWith("3.31")) {
            version = SRB_VERSION_3_3_1;
        } else if (temp.startsWith("SRB-3.3") || temp.startsWith("SRB3.3") || temp.startsWith("3.3")) {
            version = SRB_VERSION_3_3;
        } else if (temp.startsWith("SRB-3.2") || temp.startsWith("SRB3.2") || temp.startsWith("3.2")) {
            version = SRB_VERSION_3_0_2;
        } else if (temp.startsWith("SRB-3.0.2") || temp.startsWith("SRB3.0.2") || temp.startsWith("3.0.2")) {
            version = SRB_VERSION_3_0_2;
        } else if (temp.startsWith("SRB-3") || temp.startsWith("SRB3") || temp.startsWith("3")) {
            version = SRB_VERSION_3;
        } else if (temp.startsWith("SRB-2") || temp.startsWith("SRB2") || temp.startsWith("2")) {
            version = SRB_VERSION_2;
        } else if (temp.startsWith("SRB-1") || temp.startsWith("SRB1") || temp.startsWith("1")) {
            version = SRB_VERSION_1_1_8;
        }
    }

    public SRBAccount() throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        LocalFile info = new LocalFile(String.valueOf(System.getProperty("user.home")) + "/.srb/");
        if (!info.exists()) {
            info = new LocalFile(String.valueOf(System.getProperty("user.home")) + "/srb/");
        }
        if (!info.exists()) {
            throw new FileNotFoundException("Cannot find default srb account info");
        }
        this.setUserInfo(info);
    }

    public SRBAccount(String userInfoDirectory) throws FileNotFoundException, IOException {
        this(new LocalFile(userInfoDirectory));
    }

    public SRBAccount(File userInfoDirectory) throws FileNotFoundException, IOException {
        this(new LocalFile(userInfoDirectory));
    }

    public SRBAccount(GeneralFile userInfoDirectory) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (userInfoDirectory.equals(null)) {
            throw new NullPointerException("UserInfoDirectory cannot be null");
        }
        this.setUserInfo(userInfoDirectory);
    }

    public SRBAccount(String mdasEnvFile, String mdasAuthFile) throws FileNotFoundException, IOException {
        this(new LocalFile(mdasEnvFile), new LocalFile(mdasAuthFile));
    }

    public SRBAccount(File mdasEnvFile, File mdasAuthFile) throws FileNotFoundException, IOException {
        this(new LocalFile(mdasEnvFile), new LocalFile(mdasAuthFile));
    }

    public SRBAccount(GeneralFile mdasEnvFile, GeneralFile mdasAuthFile) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (mdasEnvFile.equals(null) || mdasAuthFile.equals(null)) {
            throw new NullPointerException("Mdas files cannot be null");
        }
        this.setMdasUserInfo(mdasEnvFile);
        this.readMdasAuth(mdasAuthFile);
    }

    public SRBAccount(String host, int port, String userName, String password, String homeDirectory, String mdasDomainName, String defaultStorageResource) {
        super(host, port, userName, password, homeDirectory);
        this.setProxyUserName(userName);
        this.setProxyDomainName(mdasDomainName);
        this.setDomainName(mdasDomainName);
        this.setDefaultStorageResource(defaultStorageResource);
    }

    public SRBAccount(String host, int port, String userName, String password, String homeDirectory, String mdasDomainName, String defaultStorageResource, String mcatZone) {
        super(host, port, userName, password, homeDirectory);
        this.setProxyUserName(userName);
        this.setProxyDomainName(mdasDomainName);
        this.setDomainName(mdasDomainName);
        this.setDefaultStorageResource(defaultStorageResource);
        this.setProxyMcatZone(mcatZone);
        this.setMcatZone(mcatZone);
    }

    protected void finalize() {
        super.finalize();
        this.proxyUserName = null;
        this.proxyDomainName = null;
        this.domainName = null;
        this.defaultStorageResource = null;
    }

    public void setHomeDirectory(String homeDirectory) {
        if (homeDirectory == null) {
            throw new NullPointerException("The home directory string cannot be null");
        }
        this.homeDirectory = homeDirectory;
    }

    protected void setProxyUserName(String proxyUserName) {
        if (proxyUserName == null) {
            throw new NullPointerException("The proxy user name cannot be null");
        }
        this.proxyUserName = proxyUserName;
    }

    protected void setProxyDomainName(String proxyDomainName) {
        if (proxyDomainName == null) {
            throw new NullPointerException("The proxy domain name cannot be null");
        }
        this.proxyDomainName = proxyDomainName;
    }

    public void setDomainName(String domainName) {
        if (domainName == null) {
            throw new NullPointerException("The domain name cannot be null");
        }
        this.domainName = domainName;
    }

    public void setDefaultStorageResource(String defaultStorageResource) {
        if (defaultStorageResource == null) {
            throw new NullPointerException("The default storage resource cannot be null");
        }
        this.defaultStorageResource = defaultStorageResource;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public static void setVersion(String srbVersion) {
        if (srbVersion == null) {
            throw new IllegalArgumentException("Invalid version");
        }
        if (versionNumber.get(version) == null) {
            throw new IllegalArgumentException("Invalid version");
        }
        version = srbVersion;
    }

    public void setProxyMcatZone(String proxyMcatZone) {
        this.proxyMcatZone = proxyMcatZone;
    }

    public void setMcatZone(String clientMcatZone) {
        this.clientMcatZone = clientMcatZone;
    }

    public void setExecFile(String execFile) {
        this.execFile = execFile;
    }

    public void setCertificateAuthority(String list) {
        this.certificateAuthority = list;
    }

    public void setGSSCredential(Object gssCredential) {
        this.gssCredential = gssCredential;
        this.password = null;
    }

    protected String getProxyUserName() {
        return this.proxyUserName;
    }

    protected String getProxyDomainName() {
        return this.proxyDomainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public int getOptions() {
        return this.options;
    }

    public static String getVersion() {
        return version;
    }

    static float getVersionNumber() {
        return ((Float)versionNumber.get(version)).floatValue();
    }

    public String getProxyMcatZone() {
        return this.proxyMcatZone;
    }

    public String getMcatZone() {
        return this.clientMcatZone;
    }

    public String getExecFile() {
        return this.execFile;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public Object getGSSCredential() {
        return this.gssCredential;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            SRBAccount temp = (SRBAccount)obj;
            if (!this.getHost().equals(temp.getHost())) {
                return false;
            }
            if (this.getPort() != temp.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(temp.getUserName())) {
                return false;
            }
            if (!this.getPassword().equals(temp.getPassword())) {
                return false;
            }
            if (this.getOptions() == 51 && !this.getCertificateAuthority().equals(temp.getCertificateAuthority())) {
                return false;
            }
            if (!this.getProxyUserName().equals(temp.getProxyUserName())) {
                return false;
            }
            if (!this.getProxyDomainName().equals(temp.getProxyDomainName())) {
                return false;
            }
            if (!this.getDomainName().equals(temp.getDomainName())) {
                return false;
            }
            return SRBAccount.getVersion().equals(SRB_VERSION_2) || SRBAccount.getVersion().equals(SRB_VERSION_1_1_8) || this.getProxyMcatZone().equals(temp.getProxyMcatZone()) || this.getMcatZone().equals(temp.getMcatZone());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void setUserInfo(GeneralFile userInfoDirectory) throws FileNotFoundException, IOException {
        GeneralFile mdas = FileFactory.newFile(userInfoDirectory, ".MdasEnv");
        if (!mdas.exists()) {
            mdas = FileFactory.newFile(userInfoDirectory, "MdasEnv");
        }
        this.setMdasUserInfo(mdas);
        mdas = FileFactory.newFile(userInfoDirectory, ".MdasAuth");
        if (!mdas.exists()) {
            mdas = FileFactory.newFile(userInfoDirectory, "MdasAuth");
        }
        this.readMdasAuth(mdas);
    }

    public void setMdasUserInfo(GeneralFile mdasEnvFile) throws FileNotFoundException, IOException {
        int index = 0;
        GeneralFileInputStream mdasEnvReader = null;
        try {
            mdasEnvReader = FileFactory.newFileInputStream(mdasEnvFile);
        }
        catch (FileNotFoundException e) {
            if (!version.equals(SRB_VERSION_2) && !version.equals(SRB_VERSION_1_1_8)) {
                this.setProxyUserName("ticketuser");
                this.setUserName("ticketuser");
                this.setHomeDirectory("/home/public.npaci");
                this.setPassword("");
                return;
            }
            throw e;
        }
        byte[] mdasEnvContents = new byte[(int)mdasEnvFile.length()];
        mdasEnvReader.read(mdasEnvContents);
        String mdasEnv = new String(mdasEnvContents);
        while (index >= 0) {
            if ((index = mdasEnv.indexOf("#", index)) < 0) continue;
            mdasEnv = String.valueOf(mdasEnv.substring(0, index)) + mdasEnv.substring(mdasEnv.indexOf(10, index + 1), mdasEnv.length());
        }
        index = mdasEnv.indexOf("srbHost");
        if (index < 0) {
            throw new NullPointerException("No host name found in Mdas file.");
        }
        index = mdasEnv.indexOf(39, index) + 1;
        this.setHost(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        index = mdasEnv.indexOf("srbPort");
        if (index < 0) {
            this.setPort(5544);
        } else {
            index = mdasEnv.indexOf(39, index) + 1;
            this.setPort(Integer.parseInt(mdasEnv.substring(index, mdasEnv.indexOf(39, index))));
        }
        index = mdasEnv.indexOf("srbUser");
        if (index < 0) {
            throw new NullPointerException("No user name found in Mdas file.");
        }
        index = mdasEnv.indexOf(39, index) + 1;
        this.setProxyUserName(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        this.setUserName(this.proxyUserName);
        index = mdasEnv.indexOf("mdasDomainHome");
        if (index < 0) {
            throw new NullPointerException("No home domain name found in Mdas file.");
        }
        index = mdasEnv.indexOf(39, index) + 1;
        this.setProxyDomainName(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        this.setDomainName(this.proxyDomainName);
        index = mdasEnv.indexOf("defaultResource");
        if (index < 0) {
            throw new NullPointerException("No default resource found in Mdas file.");
        }
        index = mdasEnv.indexOf(39, index) + 1;
        this.setDefaultStorageResource(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        index = mdasEnv.indexOf("AUTH_SCHEME");
        if (index >= 0) {
            String option = null;
            option = mdasEnv.substring(index = mdasEnv.indexOf(39, index) + 1, mdasEnv.indexOf(39, index));
            if (option.equals("PASSWD_AUTH")) {
                this.setOptions(48);
            } else if (option.equals("GSI_AUTH")) {
                this.setOptions(51);
            } else if (option.equals("ENCRYPT1")) {
                this.setOptions(53);
            } else {
                if (option.equals("SEA_AUTH")) {
                    throw new IllegalArgumentException("SEA_AUTH not supported");
                }
                if (option.equals("SEA_ENCRYPT")) {
                    throw new IllegalArgumentException("SEA_ENCRYPT not supported");
                }
                if (option.equals("GSI_SECURE_COMM")) {
                    throw new IllegalArgumentException("GSI_SECURE_COMM not supported");
                }
            }
        }
        if ((index = mdasEnv.indexOf("mcatZone")) >= 0) {
            index = mdasEnv.indexOf(39, index) + 1;
            this.setProxyMcatZone(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        }
        this.setMcatZone(this.proxyMcatZone);
        index = mdasEnv.indexOf("execFile");
        if (index >= 0) {
            index = mdasEnv.indexOf(39, index) + 1;
            this.setDefaultStorageResource(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        }
        if ((index = mdasEnv.indexOf("mdasCollectionHome")) < 0) {
            if (this.proxyMcatZone == null) {
                this.setHomeDirectory("/" + this.proxyMcatZone + "/" + "home" + "/" + this.userName + "." + this.domainName);
            } else {
                this.setHomeDirectory("/home/" + this.userName + "." + this.domainName);
            }
        } else {
            index = mdasEnv.indexOf(39, index) + 1;
            this.setHomeDirectory(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        }
        index = mdasEnv.indexOf("srbVersion");
        if (index > 0) {
            index = mdasEnv.indexOf(39, index) + 1;
            SRBAccount.setVersion(mdasEnv.substring(index, mdasEnv.indexOf(39, index)));
        }
    }

    public void readMdasAuth(GeneralFile mdasAuthFile) throws FileNotFoundException, IOException {
        int index = 0;
        GeneralFileInputStream mdasAuthReader = FileFactory.newFileInputStream(mdasAuthFile);
        byte[] mdasAuthContents = new byte[(int)mdasAuthFile.length()];
        mdasAuthReader.read(mdasAuthContents);
        String mdasAuth = new String(mdasAuthContents);
        StringTokenizer authTokens = new StringTokenizer(mdasAuth, String.valueOf(System.getProperty("line.separator")) + "\n");
        while (authTokens.hasMoreTokens()) {
            String token = authTokens.nextToken();
            if (token.startsWith("#")) continue;
            index = token.indexOf(System.getProperty("line.separator")) + token.indexOf("\n") + 1;
            mdasAuth = index >= 0 ? token.substring(0, index) : token;
        }
        this.setPassword(mdasAuth);
    }
}

